/* error.h - file for error messages etc. */
/* Copyright (C) 2005 Suvrit Sra (suvrit@cs.utexas.edu) */
/* Copyright The University of Texas at Austin */


/*
  <sslib-small -- sparse matrix manipulation>
  Copyright (C) 2006,2007  Suvrit Sra  <suvrit@cs.utexas.edu>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  MA  02110-1301  USA 

  The University of Texas at Austin HAS NOT YET disclaimed all copyright
  interest in the library `SSLIB-SMALL v1.0' (a library for sparse matrices)
  written by Suvrit Sra (suvrit@cs.utexas.edu)
*/

#ifndef _SSUTIL_ERROR_H
#define _SSUTIL_ERROR_H

#include <ostream>

namespace SSUtil {

  enum errors_type {
    SSUTIL_INVALID_VSIZE,
    SSUTIL_VDIM_MISMATCH,
    SSUTIL_MDIM_MISMATCH,
    SSUTIL_OUT_OF_BOUNDS,
  };
  
  class error_msg {
  public:
    errors_type err;
    const char* msg;
  };
  
  static const error_msg ssutil_errors[4] = {
    {SSUTIL_INVALID_VSIZE, "Invalid vector size"},
    {SSUTIL_VDIM_MISMATCH, "Vectors not of same size"},
    {SSUTIL_MDIM_MISMATCH, "Matrix dimensions not same"},
    {SSUTIL_OUT_OF_BOUNDS, "Array or vector index out of bounds"},
  };

}
#endif // _SSUTIL_ERROR_H
