// File: row_coord_float.h -*- c++ -*-
// Time-stamp: <22 April 2006 11:34:15 AM CDT --  suvrit>
// Impl. of row coordinate format sparse matrices

#ifndef _ROW_COORD_FLOAT_H
#define _ROW_COORD_FLOAT_H

#include "ccs_float.h"

namespace SSLib {
  /**
   * @class row_coord, contains an implementation of a row co-ordinate
   * based sparsematrix. It supports many of the operations suggested by the
   * abstract class sparsematrix. The format of the sparse matrix that is
   * loaded is as follows:
   * row1:val1 row2:val2 .... rowk:valk
   * rowx:valx rowy:valy .... rowj:valj
   * and so on...each line begins a new row of the matrix. If a row is
   * totally empty, then there should be a blank line in the file to
   * indicate that. The loaded matrix is stored internally as a CRS matrix.
   */
  class row_coord_float : public ccs_float {
    
  public:
    virtual ~row_coord_float() {
      // Free_up the data
    }

    /// Load a coordinate sparse matrix with known dimensions
    virtual int load_fast (size_t m, size_t n, size_t nz, const char*, 
                           int base = 0, char* separator = ":");

    /// Loads a general row coordinate sparse file, taking care of figuring
    /// out the number of rows, rows, nonzeros etc.
    virtual int load (const char*);
    virtual int load (const char*, bool asbin);

    virtual void error(std::string);
  };
}

#endif // _ROW_COORD_H
