/* Author: Suvrit Sra */
/* Copyright: Suvrit Sra. The Univ. of Texas at Austin. */
/* See LICENSE File for details on licensing issues */

/* This file is distributed along with SSLIB and thus is subject to the 
// Licensing that sslib itself is subject to. To see these licensing details
// Please download SSLIB and read the LICENSE File. Essentially it is the GNU LGPL
//
*/ 

#include "mex.h"

void mexFunction(int nlhs, mxArray *plhs[],
                 int nrhs, const mxArray* prhs[])
{

  double* val;
  int nz;
  int m, n, i;
  int *row, *col;
  int status;
  char* input_buf, *input_buf2;
  char* out, *out2;
  int buflen, buflen2;
  FILE* fp;
  
  if (nrhs != 2) {
    fprintf(stderr, "Error: readccs('filename prefix', 'txx|tfn|etc.')\n");
    return;
  }
  
  if (nlhs > 1) {
    fprintf(stderr, "Error: Too many output arguments.\n");
    return;
  }

  if (mxIsChar(prhs[0]) != 1) {
    fprintf(stderr, "Error: Input file name must be a string.\n");
    return;
  }
  

  /* Get the length of the input string. */
  buflen = (mxGetM(prhs[0]) * mxGetN(prhs[0])) + 1;

  /* Allocate memory for input and output strings. */
  input_buf = mxCalloc(buflen, sizeof(char));
  out =       mxCalloc(buflen + 8, sizeof(char));

  /* Copy the string data from prhs[0] into a C string 
   * input_buf. */
  status = mxGetString(prhs[0], input_buf, buflen);
  if (status != 0) 
    fprintf(stderr, "Warning: Not enough space. String is truncated.\n");
     
  /* Get the length of the input string. */
  buflen2 = (mxGetM(prhs[1]) * mxGetN(prhs[1])) + 1;
  
  /* Allocate memory for input and output strings. */
  input_buf2 = mxCalloc(buflen2, sizeof(char));
  out2 =       mxCalloc(buflen2 + 8, sizeof(char));
  
  /* Copy the string data from prhs[0] into a C string 
   * input_buf. */
  status = mxGetString(prhs[1], input_buf2, buflen2);

  if (status != 0) 
    fprintf(stderr, "Warning: Not enough space. String is truncated.\n");
  
  sprintf(out, "%s_dim", input_buf);

  fp = fopen(out, "r");
  if (fp == NULL) {
    mexWarnMsgTxt("Could not open the _dim file");
    return;
  }
     
  fscanf(fp, "%d %d %d", &m, &n, &nz);
  fclose(fp);
  sprintf (out, "%s_row_ccs", input_buf);

  plhs[0] = mxCreateSparse(m,n,nz,0);
  row = mxCalloc(sizeof(int), nz);
  col = mxCalloc(sizeof(int), (n+1));
  mxSetIr(plhs[0], row);
  mxSetJc(plhs[0], col);
  val = mxCalloc(sizeof(double), nz);
  mxSetPr(plhs[0], val);

  fp = fopen(out, "r");
  if (fp == NULL) {
    mexWarnMsgTxt("Could not open the _row_ccs file");
    return;
  }
  for (i = 0; i < nz; i++)
    fscanf(fp, "%d\n", &row[i]);

  fclose(fp);
     
  sprintf (out, "%s_col_ccs", input_buf);

  fp = fopen(out, "r");
  if (fp == NULL) {
    mexWarnMsgTxt("Could not open the _col_ccs file");
    return;
  }
  for (i = 0; i <= n; i++)
    fscanf(fp, "%d\n", &col[i]);

  fclose(fp);
     
  sprintf (out, "%s_%s_nz", input_buf, input_buf2);

  fp = fopen(out, "r");
  if (fp == NULL) {
    mexWarnMsgTxt("Could not open the nonzeros file");
    return;
  }
  
  for (i = 0; i < nz; i++)
    fscanf(fp, "%f\n", &val[i]);
  
  fclose(fp);
}
