#include "mex.h"

/*y = multmat(x,A,B), computes y = A'*B'*B*A*x,
  A,B sparse, x,y nonsparse
  Will try to use this for computing the singular value
  of the approximate KL. Note, however, that K and L are
  not symmetric in that case....
*/
void mexFunction(int nlhs, mxArray *plhs[], int nrhs, 
		 const mxArray *prhs[]){

  int i,j,k,n;
  double *va, *vx, *vy;
  int *jca, *ira; /*used for both A and B*/
  mxArray *tmp;

  if ((nrhs != 3) || (nlhs != 1)){
    mexErrMsgTxt("incorrect number of arguments: x = multmat(x,A,B)\n");
  }
  /*input*/
  n = mxGetM(prhs[1]);
  vx = mxGetPr(prhs[0]);
  va = mxGetPr(prhs[1]);
  jca = mxGetJc(prhs[1]);
  ira = mxGetIr(prhs[1]);

  /*output*/
  tmp = mxCreateDoubleMatrix(n,1,mxREAL);
  vy = mxGetPr(tmp);

  /* y = A*x */
  for (i=0; i<n; ++i){
    /* col index */
    for(j=jca[i];j<jca[i+1];++j){
      k = ira[j]; /* row index */
      vy[k] += vx[i]*va[j];
    }
  }

  va = mxGetPr(prhs[2]);
  jca = mxGetJc(prhs[2]);
  ira = mxGetIr(prhs[2]);
  vx = vy;
  plhs[0] = mxCreateDoubleMatrix(n,1,mxREAL);
  vy = mxGetPr(plhs[0]);
  /* y = B*y = B*(A*x) */
   for (i=0; i<n; ++i){
    /* col index */
    for(j=jca[i];j<jca[i+1];++j){
      k = ira[j]; /* row index */
      vy[k] += vx[i]*va[j];
    }
   }


   vx = mxGetPr(plhs[0]);
   va = mxGetPr(prhs[2]);
   jca = mxGetJc(prhs[2]);
   ira = mxGetIr(prhs[2]);
   
   /*output*/
   vy = mxGetPr(tmp);
   
   /* y = B'*x = B'*B*A*x  */
   for (i=0; i<n; ++i){
     vy[i] = 0;
     /* col index */
     for(j=jca[i];j<jca[i+1];++j){
       k = ira[j]; /* row index  */
       vy[i] += vx[k]*va[j];
     }
   }
   
   va = mxGetPr(prhs[1]);
   jca = mxGetJc(prhs[1]);
   ira = mxGetIr(prhs[1]);
   vx = vy;
   /* mxDestroyArray(plhs[0]); */
   /*   plhs[0] = mxCreateDoubleMatrix(n,1,mxREAL);  */
   vy = mxGetPr(plhs[0]);
   /* y = A'*y = A'*(B'*B*A*x)  */
   for (i=0; i<n; ++i){
     vy[i] = 0;
     /* col index */
     for(j=jca[i];j<jca[i+1];++j){
       k = ira[j]; /* row index */
       vy[i] += vx[k]*va[j];
     }
   }
   
   mxDestroyArray(tmp);
   
}
