// File: matrix_compact_float.cc
// Author: Suvrit Sra
// Time-stamp: <14 Februar 2008 02:15:25  CET --  suvrit>
// Matrix_compact base class implementation

#include "matrix_compact_float.h"
#include <cstdio>

int SSLib::matrix_compact_float::default_add (matrix_compact_float* b)
{
  if (!dimension_match(b))
    return -1;
  
  for (index_t i = 0; i < nrows(); i++)
    for (index_t j = 0; j < ncols(); j++) {
      float t = get(i, j) + b->get(i, j);
      set(i, j, t);
    }
  return 0;
}


int SSLib::matrix_compact_float::default_sub (matrix_compact_float* b)
{
  if (!dimension_match(b))
    return -1;

  for (index_t i = 0; i < nrows(); i++)
    for (index_t j = 0; j < ncols(); j++) {
      float t = get(i, j) - b->get(i, j);
      set(i, j, t);
    }
  return 0;
}

// TODO.....
int SSLib::matrix_compact_float::default_mul (matrix_compact_float* b, bool tranA, bool tranB)
{
  if (!can_be_multiplied(b, tranA, tranB))
    return -1;
  
  // Write the triple loop here
  return 0;
}

int SSLib::matrix_compact_float::default_dot (matrix_compact_float* b)
{
  if (!dimension_match(b))
    return -1;
  
  for (index_t i = 0; i < nrows(); i++)
    for (index_t j = 0; j < ncols(); j++) {
      float t = get(i, j) * b->get(i, j);
      set(i, j, t);
    }
  return 0;
}

int SSLib::matrix_compact_float::default_div (matrix_compact_float* b)
{
  if (!dimension_match(b))
    return -1;
  
  for (index_t i = 0; i < nrows(); i++)
    for (index_t j = 0; j < ncols(); j++) {
      float t = get(i, j) / b->get(i, j);
      set(i, j, t);
    }
  return 0;
}


bool SSLib::matrix_compact_float::dimension_match (matrix_compact_float* b)
{
  if (nrows() != b->nrows() || ncols() != b->ncols()) {
    char t[256];
    sprintf(t, 
            "Dimension of 'this' = {%zu, %zu} don't match with 'b' = {%zu, %zu}",
            nrows(), ncols(), b->nrows(), b->ncols());
    std::string s = std::string(t);
    matrix_error(s);
    return false;
  }
  return true;
}

bool SSLib::matrix_compact_float::can_be_multiplied (matrix_compact_float* b, bool tranA, bool tranB)
{
  bool r = true;
  if (!tranA && !tranB) {
    if (ncols() != b->nrows())
      r = false;
  } else if (!tranA && tranB) {
    if (ncols() != b->ncols())
      r = false;
  } else if (tranA && !tranB) {
    if (nrows() != b->nrows())
      r = false;
  } else if (tranA && tranB) {
    if (nrows() != b->ncols())
      r = false;
  } else {}
  if (r) return r;
  std::string s = "Incompatible dimensionns for multiplication";
  matrix_error(s);
  return r;
}

