// File: matrix_common.h  -*- c++ -*-
// Author: Suvrit Sra
// Time-stamp: <13 Februar 2008 06:41:17  CET --  suvrit>

// The common declarations and definitions for my matrix classes
// GNU LGPL comes here

#ifndef _MATRIX_COMMON_COMPACT_H_
#define _MATRIX_COMMON_COMPACT_H_

#include <cstdio>
#include <cstdlib>
#include <iostream>
#include <string>

#include "matrix_common.h"


namespace SSLib {
  typedef unsigned short int index_t;
  int read_file_header_bin_compact(FILE* fp, index_t* m, index_t* n, size_t* nz, int emt);
  int read_file_header_txt_compact(FILE* fp, index_t* m, index_t* n, size_t* nz, int emt);
  int write_file_header_bin_compact(FILE* fp, index_t* m, index_t* n, size_t* nz, int* mt);
  int write_file_header_txt_compact(FILE* fp, index_t m, index_t n, size_t nz, int mt);

  void error(const char* s);
}

#endif // _MATRIX_COMMON_COMPACT_H_
