// File: matrix_common_compact.cc
// Author: Suvrit Sra
// Time-stamp: <14 Februar 2008 11:25:45  CET --  suvrit>

#include "matrix_common_compact.h"

/*
 * Separate versions for compact matrices, that use diff. indices.....
 */
int SSLib::read_file_header_bin_compact(FILE* fp, index_t* m, index_t* n, size_t* nz, int emt)
{
  int mt;
  // read the dimension info
  if (fread(m,  sizeof(index_t), 1, fp) != 1) {
    error("Error reading M (numrows) from file");
    return -2;
  }

  if (fread(n,  sizeof(index_t), 1, fp) != 1) {
    error("Error reading N (numcols) from file");
    return -2;
  }

  if (fread(nz, sizeof(size_t), 1, fp) != 1) {
    error ("Error reading NZ from file");
    return -2;
  }

  if (fread(&mt, sizeof(int), 1, fp) != 1) {
    error ("Error reading matrix type from file");
    return -2;
  }

  if (mt != emt) {
    error ("Input file is not in expected format!");
    std::cerr << "Expected: " << emt << " GOT: " << mt << "\n";
    return -1;
  }

  return 0;
}

int SSLib::read_file_header_txt_compact(FILE* fp, index_t* m, index_t* n, size_t* nz, int emt)
{
  int mt;
  fscanf(fp, "%hu %hu %zu %d", m, n, nz, &mt);
  if (mt != emt) {
    error ("Input file is not in expected format!");
    return -1;
  }
  return 0;
}

int SSLib::write_file_header_bin_compact(FILE* fp, index_t* m, index_t* n, size_t* nz, int* mt)
{
  // Write the dimension info
  if (fwrite(m,  sizeof(index_t), 1, fp) != 1) {
    error("Error saving M (numrows) into file");
    return -2;
  }

  if (fwrite(n,  sizeof(index_t), 1, fp) != 1) {
    error("Error saving N (numcols) into file");
    return -2;
  }

  if (fwrite(nz, sizeof(size_t), 1, fp) != 1) {
    error ("Error saving NZ into file");
    return -2;
  }

  if (fwrite(mt, sizeof(int), 1, fp) != 1) {
    error ("Error saving matrix type into file");
    return -2;
  }
  return 0;
}

int SSLib::write_file_header_txt_compact(FILE* fp, index_t m, index_t n, size_t nz, int mt)
{
  fprintf(fp, "%hu %hu %zu %d\n", m, n, nz, mt);
  return 0;
}

