// File: matrix_common.h  -*- c++ -*-
// Author: Suvrit Sra
// Time-stamp: <04 October 2006 03:20:14 PM CDT --  suvrit>

// The common declarations and definitions for my matrix classes
// GNU LGPL comes here

#ifndef _MATRIX_COMMON_H_
#define _MATRIX_COMMON_H_

#include <cstdio>
#include <cstdlib>
#include <iostream>
#include <string>

namespace SSLib {
  /// Types of matrices. As of now, not really used anywhere in the library
  /// itself, but can be exploited by an external program.
  enum matrix_type {
    ZEROS,
    CONST,
    IDENTITY,
    DIAGONAL,
    SYMMETRIC,
    LOWERTRI,
    UPPERTRI,
    UPPERHESS,
    LOWERHESS,
    TRIDIAG,
    BIDIAG,
    GENERAL,
    NONNEG
  };

  enum storage_type {
    M_SELF = 0,
    M_DENSE,
    M_CCS,
    M_CRS,
    M_COORD_CRS,
    M_COORD_CCS,
    M_HB,
    M_MATLAB,
    M_ROWCOORD,
    M_COLCOORD,
    M_DENSE_FLOAT=100,
    M_CCS_FLOAT,
    M_CRS_FLOAT,
    M_COORD_CRS_FLOAT,
    M_COORD_CCS_FLOAT,
    M_HB_FLOAT,
    M_MATLAB_FLOAT,
    M_ROWCOORD_FLOAT,
    M_COLCOORD_FLOAT,
  };

  int read_file_header_bin(FILE* fp, size_t* m, size_t* n, size_t* nz, int* mt, int emt);
  int read_file_header_txt(FILE* fp, size_t* m, size_t* n, size_t* nz, int* mt, int emt);
  int write_file_header_bin(FILE* fp, size_t* m, size_t* n, size_t* nz, int* mt);
  int write_file_header_txt(FILE* fp, size_t m, size_t n, size_t nz, int mt);

  void error(const char* s);
}

#endif // _MATRIX_COMMON_H_
