// File: matrix_common.cc
// Author: Suvrit Sra
// Time-stamp: <23 February 2010 10:37:38 AM CET --  suvrit>

#include "matrix_common.h"

/**
 * @params
 * - m   num of rows
 * - n   num of cols
 * - nz  num of nonzeros
 * - mt  matrix type
 * - emp expected matrix type
 */
int SSLib::read_file_header_bin(FILE* fp, size_t* m, size_t* n, size_t* nz, int* mt, int emt)
{
  // read the dimension info
  if (fread(m,  sizeof(size_t), 1, fp) != 1) {
    error("Error reading M (numrows) from file");
    return -2;
  }

  if (fread(n,  sizeof(size_t), 1, fp) != 1) {
    error("Error reading N (numcols) from file");
    return -2;
  }

  if (fread(nz, sizeof(size_t), 1, fp) != 1) {
    error ("Error reading NZ from file");
    return -2;
  }

  /**
   if (fread(mt, sizeof(int), 1, fp) != 1) {
    error ("Error reading matrix type from file");
    return -2;
  }

  if (*mt != emt) {
    error ("Input file is not in expected format!");
    std::cerr << "Expected: " << emt << " GOT: " << *mt << "\n";
    return -1;
  }
  */
  return 0;
}

int SSLib::read_file_header_txt(FILE* fp, size_t* m, size_t* n, size_t* nz, int* mt, int emt)
{
  int r;
  r=fscanf(fp, "%zu %zu %zu %d", m, n, nz, mt);
  if (*mt != emt) {
    error ("Input file is not in expected format!");
    return -1;
  }
  return 0;
}

int SSLib::write_file_header_bin(FILE* fp, size_t* m, size_t* n, size_t* nz, int* mt)
{
  // Write the dimension info
  if (fwrite(m,  sizeof(size_t), 1, fp) != 1) {
    error("Error saving M (numrows) into file");
    return -2;
  }

  if (fwrite(n,  sizeof(size_t), 1, fp) != 1) {
    error("Error saving N (numcols) into file");
    return -2;
  }

  if (fwrite(nz, sizeof(size_t), 1, fp) != 1) {
    error ("Error saving NZ into file");
    return -2;
  }

  if (fwrite(mt, sizeof(int), 1, fp) != 1) {
    error ("Error saving matrix type into file");
    return -2;
  }
  return 0;
}

int SSLib::write_file_header_txt(FILE* fp, size_t m, size_t n, size_t nz, int mt)
{
  fprintf(fp, "%zu %zu %zu %d\n", m, n, nz, mt);
  return 0;
}

void SSLib::error (const char* s)
{
  std::cerr << "ERROR: " << s << "\n";
}

