// File: matrix.cc
// Author: Suvrit Sra
// Time-stamp: <01 August 2006 03:52:20 PM CDT --  suvrit>
// Matrix base class implementation

#include "matrix.h"
#include <cstdio>

int SSLib::matrix::default_add (matrix* b)
{
  if (!dimension_match(b))
    return -1;
  
  for (size_t i = 0; i < nrows(); i++)
    for (size_t j = 0; j < ncols(); j++) {
      double t = get(i, j) + b->get(i, j);
      set(i, j, t);
    }
  return 0;
}


int SSLib::matrix::default_sub (matrix* b)
{
  if (!dimension_match(b))
    return -1;

  for (size_t i = 0; i < nrows(); i++)
    for (size_t j = 0; j < ncols(); j++) {
      double t = get(i, j) - b->get(i, j);
      set(i, j, t);
    }
  return 0;
}

// TODO.....
int SSLib::matrix::default_mul (matrix* b, bool tranA, bool tranB)
{
  if (!can_be_multiplied(b, tranA, tranB))
    return -1;
  
  // Write the triple loop here
  return 0;
}

int SSLib::matrix::default_dot (matrix* b)
{
  if (!dimension_match(b))
    return -1;
  
  for (size_t i = 0; i < nrows(); i++)
    for (size_t j = 0; j < ncols(); j++) {
      double t = get(i, j) * b->get(i, j);
      set(i, j, t);
    }
  return 0;
}

int SSLib::matrix::default_div (matrix* b)
{
  if (!dimension_match(b))
    return -1;
  
  for (size_t i = 0; i < nrows(); i++)
    for (size_t j = 0; j < ncols(); j++) {
      double t = get(i, j) / b->get(i, j);
      set(i, j, t);
    }
  return 0;
}


bool SSLib::matrix::dimension_match (matrix* b)
{
  if (nrows() != b->nrows() || ncols() != b->ncols()) {
    char t[256];
    sprintf(t, 
            "Dimension of 'this' = {%d, %d} don't match with 'b' = {%d, %d}",
            nrows(), ncols(), b->nrows(), b->ncols());
    std::string s = std::string(t);
    matrix_error(s);
    return false;
  }
  return true;
}

bool SSLib::matrix::can_be_multiplied (matrix* b, bool tranA, bool tranB)
{
  bool r = true;
  if (!tranA && !tranB) {
    if (ncols() != b->nrows())
      r = false;
  } else if (!tranA && tranB) {
    if (ncols() != b->ncols())
      r = false;
  } else if (tranA && !tranB) {
    if (nrows() != b->nrows())
      r = false;
  } else if (tranA && tranB) {
    if (nrows() != b->ncols())
      r = false;
  } else {}
  if (r) return r;
  std::string s = "Incompatible dimensionns for multiplication";
  matrix_error(s);
  return r;
}

