/* Author: Suvrit Sra */
/* Copyright: Suvrit Sra. The Univ. of Texas at Austin. */
/* See LICENSE File for details on licensing issues */

/* This file is distributed along with SSLIB and thus is subject to the 
// Licensing that sslib itself is subject to. To see these licensing details
// Please download SSLIB and read the LICENSE File. Essentially it is the GNU LGPL
//
*/ 

#include "mex.h"

void mexFunction(
     int nlhs, mxArray *plhs[],
     int nrhs, const mxArray* prhs[])
{

  double* val;
     int nz;
     int m, n, i;
     int *row, *col;
     int status;
     char* input_buf, *input_buf2;
     char* out, *out2;
     int buflen, buflen2;
     FILE* fp;

     if (nrhs < 2 || nrhs > 3) {
       fprintf(stderr, "Error: matlab2ccs('filename prefix', X, 'txx|tfn|etc.')\n");
      return;
     }

     if (nlhs > 0) {
       fprintf(stderr, "Error: Too many output arguments.\n");
       return;
     }

     if (!mxIsSparse(prhs[1])) {
       fprintf(stderr, "Error: Input matrix must be sparse. Use sparse(X)\n");
     }

     if (mxIsChar(prhs[0]) != 1) 
       fprintf(stderr, "Error: Input file name must be a string.\n");


     /* Get the length of the input string. */
     buflen = (mxGetM(prhs[0]) * mxGetN(prhs[0])) + 1;

     /* Allocate memory for input and output strings. */
     input_buf = mxCalloc(buflen, sizeof(char));
     out =       mxCalloc(buflen + 8, sizeof(char));

     /* Copy the string data from prhs[0] into a C string 
      * input_buf. */
     status = mxGetString(prhs[0], input_buf, buflen);
     if (status != 0) 
       fprintf(stderr, "Warning: Not enough space. String is truncated.\n");
     
     if (nrhs == 3) {
       /* Get the length of the input string. */
       buflen2 = (mxGetM(prhs[2]) * mxGetN(prhs[2])) + 1;

       /* Allocate memory for input and output strings. */
       input_buf2 = mxCalloc(buflen2, sizeof(char));
       out2 =       mxCalloc(buflen2 + 8, sizeof(char));

       /* Copy the string data from prhs[0] into a C string 
        * input_buf. */
       status = mxGetString(prhs[2], input_buf2, buflen2);
     } else {
       input_buf2 = "txx";
     }

     if (status != 0) 
      fprintf(stderr, "Warning: Not enough space. String is truncated.\n");

     val     = mxGetPr(prhs[1]);
     col  = mxGetJc(prhs[1]);
     row  = mxGetIr(prhs[1]);

     m    = mxGetM(prhs[1]);
     n    = mxGetN(prhs[1]);
     nz   = mxGetNzmax(prhs[1]);

     sprintf(out, "%s_dim", input_buf);

     fp = fopen(out, "w");
     if (fp == NULL) {
       fprintf(stderr, "Could not open the _dim file");
       return;
     }
     
     fprintf(fp, "%d %d %d", m, n, nz);
     fclose(fp);
     sprintf (out, "%s_row_ccs", input_buf);

     fp = fopen(out, "w");
     if (fp == NULL) {
       fprintf(stderr, "Could not open the _row_ccs file");
       return;
     }
     for (i = 0; i < nz; i++)
       fprintf(fp, "%d\n", row[i]);

     fclose(fp);
     
     sprintf (out, "%s_col_ccs", input_buf);

     fp = fopen(out, "w");
     if (fp == NULL) {
       fprintf(stderr, "Could not open the _col_ccs file");
       return;
     }
     for (i = 0; i <= n; i++)
       fprintf(fp, "%d\n", col[i]);

     fclose(fp);
     
     sprintf (out, "%s_%s_nz", input_buf, input_buf2);

     fp = fopen(out, "w");
     if (fp == NULL) {
       fprintf(stderr, "Could not open the _txx_nz file");
       return;
     }

     for (i = 0; i < nz; i++)
       fprintf(fp, "%f\n", val[i]);

     fclose(fp);
}
