// File: matlab.h -*- c++ -*-
// Time-stamp: <05 September 2005 11:27:29 AM CDT --  suvrit>
// Matlab sparse matrix format

#ifndef MATLAB_H
#define MATLAB_H

#include "ccs.h"

namespace SSLib {

  /**
   * @class matlab
   * The matlab sparse matrix class in its internal format is just the
   * traditional CCS class, whereby all we need to know is how to load and
   * save it, for the rest the functionality is inherited from CCS.
   */
  class matlab : public ccs {
    int load_bin (const char* file);
  public:
    virtual ~matlab() { 
      free_data();
    }
    
    virtual int load(const char*);
    virtual int load(const char*, bool asbin);

    virtual void error(std::string);
    // Taken from the online .pdf describng .mat file format.
    enum MatlabTypes {
      miINT8 = 1,
      miUINT8,
      miINT16,
      miUINT16,
      miINT32,
      miUINT32,
      miSINGLE,
      // Reserved
      miDOUBLE = 9,
      // 2 reserved
      miINT64 = 12,
      miUINT64,
      miMATRIX,
      miCOMPRESSED,
      miUTF8,
      miUTF16,
      miUTF32,
    };
  };

}


#endif
