// File: matlab.cc
// Author: Suvrit Sra
// Time-stamp: <06 November 2005 05:51:31 PM CST --  suvrit>

#include "matlab.h"
#include <cstdlib>
#include <cstdio>
#include <cstring>
#include <netinet/in.h>

int SSLib::matlab::load(const char* fil)
{
  FILE* fp = fopen(fil, "r");
  if (!fp) {
    error("Could not load " + std::string(fil));
    return 1;
  }

  char buf[1024];

  // REMOVE THIS DEPENDENCY
  sprintf(buf, "%s.dim", fil);
  FILE* fpd = fopen(buf, "r");
  if (!fpd) {
    std::cerr << "Dimension file: " << buf << " is missing\n";
    std::cerr << "You need to supply m n nz in the dimension file\n";
    return 2;
  }
  size_t m, n, nz;
  fscanf(fpd, "%zu %zu %zu", &m, &n, &nz);
  
  matrix_alloc(m, n, nz);

  // The data structs are already allocated. so we can start fillin em up
  // Remember, matlab indexes matrices from 1 instd. of 0, so have to do the
  // appropriate translation.
  size_t idx = 0;
  long pcolumn = -1;
  m_colptrs[0] = 0;		// Init it!

  long col, row;
  double val;
  std::cout << "Beginning to load matrix...\n";
  while (!feof(fp)) {
    // I am assuming that matlb sparse matrix as a text file is saved as
    // (rowx, col1, val1)
    // (rowy, col1, val2)
    // ...
    // (rowz, colk, valk)
    // If it is the other way round, just call transpose in matlab OR use the
    // class CRS to load the matrix and transpose it....or just use the load_mat_rowmajor
    fscanf(fp, "%ld %ld %lf", &row, &col, &val);
    if (col > (long)ncols() || row > (long)nrows()) {
      std::cerr << "Input matrix too big, stopping at ("
                << row << " , " << col << ") entry\n";
      break;
    }
    // Since we are readin in matlab indices, subtract one
    --col;               
    --row;
    

    if (col > pcolumn) {
      for (long c = pcolumn + 1; c <= col; c++)
        m_colptrs[c] = idx;
      pcolumn = col;
    }
    m_rowindx[idx] = row;
    m_val[idx]     = val;
    ++idx;
  }
  
  m_colptrs[n] = nz + 1;     // Convenience value
  //std::cout << "Built matrix " << M << " x " << (doc+1) << " with " << (idx-1) << " nonzeros\n";
  return 0;
}

// Load bin can load directly into the CCS structures, as
// matlab .mat fomrat for sparse matrices is essentially CCS!!
int SSLib::matlab::load(const char* fil, bool asbin)
{
  if (asbin) 
    return load_bin(fil);
  else 
    return load(fil);
}

// As of now reads in only 2 dimensional .mat sparse matrix files
int SSLib::matlab::load_bin (const char* fil)
{
  FILE* fp = fopen (fil, "rb");
  if (!fp) {
    return 1;
  }

  char buf[124];
  fread(buf, 124, 1, fp);	// read the .mat file header
  fread(buf, 4, 1, fp);

  bool swap = false;
  // The bytes buf[2] buf[3] tell the endianness
  if (buf[2] == 'I' && buf[3] == 'M')
    swap = true;

  // If one has to do byte swapping
  uint data_type = 0;
  uint num_bytes = 0;

  fread(&data_type, 4, 1, fp);
  
  if (swap) ntohl(data_type);

  fread(&num_bytes, 4, 1, fp);
  if (swap)  ntohl(num_bytes);

  if (data_type != miMATRIX) {
    if (data_type == miCOMPRESSED) {
      std::cerr << "Matlab v7 Compressed .MAT file. Please use save ... -v6 instead\n";
      return 1;
    } else {
      std::cerr << "Not a sparsematrix .mat file. Received" << data_type << "\n";
      return 1;
    }
  }

  uint aryflgs[4];
  fread(aryflgs, 4, 4, fp);
  for (int i = 0; i < 4; i++)
    if (swap) ntohl(aryflgs[i]);

  int dimary[4];
  fread(dimary, 4, 2, fp);
  if (swap)  ntohl(dimary[0]);
  if (swap)  ntohl(dimary[1]);

  if (dimary[1] == 0) {
    setsize(0, 0, 0);
    return 0;
  } else if (dimary[1] == 4) {
    std::cerr << "Single dimensional sparse matrices not supported\n";
    return 1;
  } 

  fread(&dimary[2], 4, 2, fp);

  if (swap)  ntohl(dimary[2]);
  if (swap)  ntohl(dimary[3]);

  uint m = dimary[2];
  uint n = dimary[3];
  uint nz = aryflgs[3];

  setsize(m, n, nz);

  int nl;
  fread(&nl, 2, 1, fp);
  ntohs(nl);
  int tmp;
  fread(&tmp, 2, 1, fp);
  ntohs(tmp);
  int pad = 0;
  if (nl <= 4) {
    nl = 4;
  } else if (nl < 12) {
    nl = 16;
  } else {
    pad = 12;
    nl -= 12;
    if ((nl % 8) != 0) {
      nl += (8 -  (nl % 8));
    } // Pad to a 8 byte thing.
  }

  char* b = new char[nl + pad];
  fread(b, nl + pad, 1, fp);
  
  matrix_alloc(m, n, nz);

  uint tag[2];
  fread(tag, 4, 2, fp);
  if (swap)  ntohl(tag[0]);
  if (swap) ntohl(tag[1]);

  fread(m_rowindx, 4, nonzeros(), fp);
  if (nz % 2 == 1) {
    fread(&pad, 4, 1, fp);
  }
  fread(tag, 4, 2, fp);
  fread(m_colptrs, 4, ncols() + 1, fp);
  if (n % 2 == 0)
    fread(&pad, 4, 1, fp);

  fread(tag, 4, 2, fp);
  if (swap)  ntohl(tag[0]);
  if (swap)  ntohl(tag[1]);
  if (tag[0] != miDOUBLE) {
    std::cerr << "Loading matlab .MAT file failed. Can read only DOUBLE precision\n";
    std::cerr << "Received type " << tag[0] << "\n";
    return 1;
  }
  fread(m_val,  8, nz, fp);

  fclose(fp);
  return 0;
}

void SSLib::matlab::error (std::string s)
{
  std::cerr << "MATLAB:"  << s << std::endl;
}
