// File: harwell_boeing_float.h     -*- c++ -*-
// Time-stamp: <13 June 2006 09:56:56 PM CDT --  suvrit>
// The harwell boeing sparse matrix format.

#ifndef HARWELL_BOEING_FLOAT_H
#define HARWELL_BOEING_FLOAT_H

#include "sparsematrix_float.h"
#include "ccs_float.h"


namespace SSLib {

  /**
   * A harwell boeing format sparse matrix is just a CCS matrix. In this
   * particular implementation, I just read and ignore the header. The I/O
   * functions permit loading and saving this matrix. All other
   * functionality is inherited from the CCS class and is available directly.
   */
  class harwell_boeing_float : public ccs_float {
    char title[74];
  public:
    harwell_boeing_float() : ccs_float() {

    }
    virtual ~harwell_boeing_float() {}
    
  public:
    virtual void error(std::string);
    int load(const char*);
    int load(const char*, bool asbin);
    int save (const char*, bool asbin);
    /// Write out matrix in a specified way
    virtual int    save(const char*, bool asbin, int typ);
    int save_as_ccs(const char* f, bool asbin);
  };
}

#endif
