// File: harwell_boeing_float.cc
// Time-stamp: <13 June 2006 10:08:46 PM CDT --  suvrit>
// Implements the harwell_boeing class

#include "harwell_boeing_float.h"
#include "exceptions.h"

#include <cstdio>

using namespace SSLib;

int harwell_boeing_float::load(const char* fil)
{
  FILE* fp = fopen(fil, "r");
  if (!fp) {
    std::string s = "Could not open" + std::string(fil);
    error(s);
    return -1;
  }
  uint nrow, ncol, nnz;
  // We skip over all the strings in the file.
  fscanf(fp, "%72c%*s", title);
  title[73]='\0';
  fscanf(fp, "%*s");
  fscanf(fp, "%*s%u%u%u%*d", &nrow, &ncol, &nnz);
  
  

  //std::cout << "Read file header (" << nrow << "," << ncol << "," << nnz << ")\n";
  /* as of now i am skipping the data format line
   * might implement it if the demand arises.
   */
  fscanf(fp, "%*s %*s %*s %*s");
  
  // Now allocate the matrix
  matrix_alloc(nrow, ncol, nnz);
  // Read the col pointers
  for (uint i = 0; i <= ncol; i++) 
    fscanf(fp, "%u", &m_colptrs[i]);

  // We need to subtract 1 from the values, because traditional HB format
  // has arrays starting from 1
  for (uint i = 0; i < ncol; i++)
    m_colptrs[i] -= 1;
  m_colptrs[ncol] = nnz;
  for (uint i = 0; i < nnz; i++) {
    fscanf(fp, "%u", &m_rowindx[i]);
    m_rowindx[i]--;
  }
  for (uint i = 0; i < nnz; i++) {
    fscanf(fp, "%f", &m_val[i]);
  }
  fclose(fp);
  return 0;
}

int harwell_boeing_float::load(const char* f, bool asbin)
{
  error("Not yet implemented binary HB files");
  return -1;
}

int harwell_boeing_float::save (const char* f, bool asbin)
{
  if (asbin) {
    error("Not yet implemented binary HB files");
    return -1;
  }
  
  return 0;
}

int harwell_boeing_float::save (const char* f, bool asbin, int typ)
{
  return ((ccs_float*)this)->save(f, asbin, typ);
}

int harwell_boeing_float::save_as_ccs(const char* f, bool asbin)
{
  return ((ccs_float*)this)->save(f, asbin);
}

void harwell_boeing_float::error (std::string s)
{
  std::cerr << "harwell_boeing:"  << s << std::endl;
}
