// File: harwell_boeing.h     -*- c++ -*-
// Time-stamp: <13 June 2006 09:56:48 PM CDT --  suvrit>
// The harwell boeing sparse matrix format.

#ifndef HARWELL_BOEING_H
#define HARWELL_BOEING_H

#include "sparsematrix.h"
#include "ccs.h"


namespace SSLib {

  /**
   * A harwell boeing format sparse matrix is just a CCS matrix. In this
   * particular implementation, I just read and ignore the header. The I/O
   * functions permit loading and saving this matrix. All other
   * functionality is inherited from the CCS class and is available directly.
   */
  class harwell_boeing : public ccs {
    char title[74];
  public:
    harwell_boeing() : ccs() {

    }
    virtual ~harwell_boeing() {}
    
  public:
    virtual void error(std::string);
    int load(const char*);
    int load(const char*, bool asbin);
    int save (const char*, bool asbin);
    /// Write out matrix in a specified way
    virtual int    save(const char*, bool asbin, int typ);
    int save_as_ccs(const char* f, bool asbin);
  };
}

#endif
