// File: harwell_boeing.cc
// Time-stamp: <23 February 2010 10:40:39 AM CET --  suvrit>
// Implements the harwell_boeing class

#include "harwell_boeing.h"
#include "exceptions.h"

#include <cstdio>

using namespace SSLib;

int harwell_boeing::load(const char* fil)
{
  FILE* fp = fopen(fil, "r");
  if (!fp) {
    std::string s = "Could not open" + std::string(fil);
    error(s);
    return -1;
  }
  size_t nrow, ncol, nnz;
  size_t st;
  // We skip over all the strings in the file.
  st=fscanf(fp, "%72c%*s", title);
  title[73]='\0';
  st=fscanf(fp, "%*s");
  st=fscanf(fp, "%*s%zu%zu%zu%*d", &nrow, &ncol, &nnz);
  
  

  //std::cout << "Read file header (" << nrow << "," << ncol << "," << nnz << ")\n";
  /* as of now i am skipping the data format line
   * might implement it if the demand arises.
   */
  st=fscanf(fp, "%*s %*s %*s %*s");
  
  // Now allocate the matrix
  matrix_alloc(nrow, ncol, nnz);
  // Read the col pointers
  for (size_t i = 0; i <= ncol; i++) 
    st=fscanf(fp, "%zu", &m_colptrs[i]);

  // We need to subtract 1 from the values, because traditional HB format
  // has arrays starting from 1
  for (size_t i = 0; i < ncol; i++)
    m_colptrs[i] -= 1;
  m_colptrs[ncol] = nnz;
  for (size_t i = 0; i < nnz; i++) {
    st=fscanf(fp, "%zu", &m_rowindx[i]);
    m_rowindx[i]--;
  }
  for (size_t i = 0; i < nnz; i++) {
    st=fscanf(fp, "%lf", &m_val[i]);
  }
  fclose(fp);
  return 0;
}

int harwell_boeing::load(const char* f, bool asbin)
{
  error("Not yet implemented binary HB files");
  return -1;
}

int harwell_boeing::save (const char* f, bool asbin)
{
  if (asbin) {
    error("Not yet implemented binary HB files");
    return -1;
  }
  
  return 0;
}

int harwell_boeing::save (const char* f, bool asbin, int typ)
{
  return ((ccs*)this)->save(f, asbin, typ);
}

int harwell_boeing::save_as_ccs(const char* f, bool asbin)
{
  return ((ccs*)this)->save(f, asbin);
}

void harwell_boeing::error (std::string s)
{
  std::cerr << "harwell_boeing:"  << s << std::endl;
}
