// File: exceptions.h      -*- c++ -*-
// Author: Suvrit Sra
// Time-stamp: <05 September 2005 11:19:17 AM CDT --  suvrit>

// The matrix exception classes

#ifndef _MY_EXCEPTIONS_H
#define _MY_EXCEPTIONS_H

#include <iostream>

namespace SSLib {

  /** @name Exceptions
   * The various exception classes
   */
  
  /*@{*/
  
  /** @class matrix_alloc 
   * Exception class for memory allocation stuff for general matrices
   */
  class matrix_alloc {
  public:
    matrix_alloc(std::string s) {
      std::cerr << "ERROR: " << s << std::endl;
    }
  };
  
  class sparsematrix_exception {
    std::string msg;
  public:
    sparsematrix_exception (std::string s) {
      msg = s;
    }
    virtual void print_information() {
      std::cerr << msg;
    }
    virtual ~sparsematrix_exception() {}
    std::string getMsg() { return msg; }
  };
    
  /** @class exception_malloc
   * Exception class
   */
  class exception_malloc : public sparsematrix_exception {
    uint m;
    uint n;
  public:
    
    exception_malloc (std::string s) : sparsematrix_exception(s) { }
    exception_malloc (std::string s, uint mm, uint nn) : sparsematrix_exception(s) {
        
    }
    void print_information() {
      std::cerr << getMsg() << " ROWS = " << m << " COLS = " << n << std::endl;
    }
  };

  class exception_fileio : public sparsematrix_exception {
  public:
    exception_fileio(std::string s) : sparsematrix_exception(s) {}
  };
  /*@}*/
}

#endif
