// File: driver.h -*- c++ -*-
// Author: Suvrit Sra
// Time-stamp: <03 October 2006 08:21:26 PM CDT --  suvrit>

// The driver class for testing out the various sparsematrix routines

#ifndef _SPARSE_DRIVER_H_
#define _SPARSE_DRIVER_H_

#include <map>

#include "matrix_common.h"
#include "matrix_float.h"
#include "matrix.h"
#include "sparsematrix.h"
#include "ccs.h"
#include "crs.h"
#include "harwell_boeing.h"
#include "matlab.h"
#include "dense_matrix.h"
#include "dense_matrix_float.h"
#include "coord.h"
#include "col_coord.h"

#define ERROR(x) std::cerr << x << std::endl
using namespace SSLib;


/**
 * This is a sample driver, that exercises some of the features of the
 * sparse matrix classes in the SSLib. This driver class is easily extended
 * to permit the addition of new features. However, I will not be developing
 * this driver too much, because it will be superceded by my more general
 * MAT tool.
 */
class driver {
  enum cmd_type{
    LOAD, UNLOAD, SAVE, PRINT, LOADVEC, SET, HELP, EIGS, ADD,
    SUB,    MUL,    DOAX,    DOATX, SHELLCMD, TRAN,SIZE, SETP,
    SETBIN, DOATA, DOAAT, TESTC, RANDMAT, RANDVEC, SETBASE,
  };

  bool load_save_asbin;
  int  max_powerit;

  typedef int (driver::*_intfn) ();
#define afunc(x, y) std::pair<std::string, _intfn>((x), (y))
#define NCOMMANDS 30
  std::map <std::string, _intfn> function_table;

private:
  matrix* mat1, *mat2, *mat3;
  matrix_float* smat1, *smat2, *smat3;

  dense_matrix_float* sev;
  dense_matrix *ev;             // Eigenvectors
  vector *ew;                   // Eigenvalues
  vector_float* sew;            // singp eigenwerte
  vector* vec, *r;
  vector_float* svec, *sr;      // 

  gsl_matrix_view view;              // for the eigenvectors.
  gsl_matrix_float_view sview;
  char* version;
  const char* prompt;
  char* line;
  bool singp;
  bool bin;
  int base;

  typedef SSLib::storage_type MatType;
  enum VERBLVL { QUIET, NORMAL, EXTRA};
  std::string* cmdtable;
  int  m1type, m2type;
  int  verbose;

  char* input_line;
  char* curpos;
public:
  driver (int argc, char** argv);
  int    start();               /* Start the cmd loop */
  
private:
  void set_single_precision(bool sp) { singp = sp;}
  void show_help(int);
  void show_help();
  void init_functions();
  
  std::string next_word(bool = false);
  //char* parse_command(char*);
  char* readline_getline();
  /**
   * The workhorse functions
   */

private:
  int load();
  int load_float();

  int unload();
  int unload_float();

  int save();
  int save_float();
  
  int print();
  int print_float();

  int loadvec();
  int loadvec_float();

  int set();
  int help();

  int eigs();
  int eigs_float();

  int add();
  int sub();
  int mul();

  int doax();
  int doax_float();

  int doatx();
  int doatx_float();

  int doata();
  int doata_float();
  int do_ata_helper(matrix*, const char*);

  int doaat();
  int do_aat_helper(matrix*, const char*);
  int doaat_float();

  int sh();

  int tran();
  
  matrix* get_matrix();
  matrix_float* get_matrix_float();

  int size();
  int setp();
  int setb();
  int test();
  int setbase();

  int randmat();
  int randvec();

  int compute_eigenpairs (matrix*, uint);
};

#endif 
