/* File: coord_struct.h */
// Author: Suvrit Sra
// Time-stamp: <07 August 2006 05:11:31 PM CDT --  suvrit>

// Provides a struct to wrap the (i, j, v) representation

#ifndef _COORD_STRUCT_H_
#define _COORD_STRUCT_H_

struct coord_struct_col {
  unsigned int m_rowindx;
  unsigned int m_colindx;
  double       m_val;
};

inline bool operator < (const coord_struct_col& a1, const coord_struct_col& a2) {
  if (a1.m_colindx < a2.m_colindx)
    return true;
  if (a1.m_colindx == a2.m_colindx)
    return (a1.m_rowindx < a2.m_rowindx);
  return false;
}

struct coord_struct_row {
  unsigned int m_rowindx;
  unsigned int m_colindx;
  double       m_val;
};

inline bool operator < (const coord_struct_row& a1, const coord_struct_row& a2) {
  if (a1.m_rowindx < a2.m_rowindx)
    return true;
  if (a1.m_rowindx == a2.m_rowindx)
    return (a1.m_colindx < a2.m_colindx);
  return false;
}

#endif // _COORD_STRUCT_H_
