// File: coord_float.h -*- c++ -*-
// Time-stamp: <21 April 2006 05:23:09 PM CDT --  suvrit>
// Impl. of coordinate format sparse matrices

#ifndef _COORD_FLOAT_H
#define _COORD_FLOAT_H

#include "crs_float.h"

namespace SSLib {
  /**
   * @class coord, contains an implementation of a co-ordinate based
   * sparsematrix. It supports many of the operations suggested by the abstract
   * class sparsematrix. Essentially, It just has code to load the (i, j, v)
   * format as a CRS matrix.
   *
   */
  class coord_float : public crs_float {
    
  public:
    virtual ~coord_float() {
      // Free_up the data
    }

    /// Load a row major coordinate file whose params are known in advance
    virtual int load_fast (uint m, uint n, uint nz, const char*, int base = 0);

    /// Loads a general (i, j, v) format file, taking care of figuring out
    /// the number of rows, cols, nonzeros etc.
    virtual int load (const char*);
    virtual int load (const char*, bool asbin);

    virtual void error(std::string);
  };
}

#endif // _COORD_FLOAT_H
