// File: coord_float.cc
// Author: Suvrit Sra
// Time-stamp: <21 April 2006 05:23:52 PM CDT --  suvrit>

// Implements the coordinate based class.

#include <iostream>
#include <cstdio>

#include "coord_float.h"

/**
 * Assumes file is stored in (i, j, val) format as a text file.
 * It does not matter if the (i, j, val) are ordered or not.
 * The indices are expected to begin from '0'
 * @todo  Introduce 'base' for indices, to allow dealing with matlab
 * matrices.
 * @todo To write this function.
 */
int SSLib::coord_float::load(const char* fil)
{
  FILE* fp = fopen(fil, "r");
  if (!fp) {
    error("Could not load " + std::string(fil));
    return 1;
  }

  // We don't assume anything about the ordering of the indices. 
  
  return 2;
}


/**
 * This function assumes that the data is stored in the file in the
 * following manner.
 * (i1,j1,v1)
 * (i1,j2,v2)
 * (i1,j3,v3)
 * ...
 * ...
 * (ik,jx,vnz)
 * Default: indices are expected to start at '0' and not '1' like
 * matlab. The parameter 'base' can be used to control that. Base = 1 gives
 * matlab indexing and base = 0 is the 'C' style indexing.
 */
int SSLib::coord_float::load_fast (uint m, uint n, uint nz, const char* fil, int base)
{
  
  FILE* fp = fopen(fil, "r");
  if (!fp) {
    error("Could not load " + std::string(fil));
    return 1;
  }

  matrix_alloc(m, n, nz);

  size_t idx = 0;
  long prow = -1;
  m_rowptrs[0] = 0;		// Init it!
  long col, row;
  float val;

  while (!feof(fp)) {
    fscanf(fp, "%ld %ld %lf", &row, &col, &val);
    if (col > (long)ncols() || row > (long)nrows()) {
      std::cerr << "Input matrix too big, stopping at ("
                << row << " , " << col << ") entry\n";
      break;
    }

    if (base > 0) {
      row -= base;
      col -= base;
    }

    if (row > prow) {
      for (long r = prow + 1; r <= row; r++)
        m_rowptrs[r] = idx;
      prow = row;
    }
    m_colindx[idx] = col;
    m_val[idx]     = val;
    ++idx;
  }
  fclose(fp);
  return 0;
}

int SSLib::coord_float::load(const char* fil, bool asbin)
{
  return -1;
}

void SSLib::coord_float::error (std::string s)
{
  std::cerr << "COORD_FLOAT:"  << s << std::endl;
}

