// File: coord_crs.h -*- c++ -*-
// Time-stamp: <03 September 2006 06:34:30 PM CDT --  suvrit>
// Impl. of (i, j, val) type matrices, internally stored in CRS

#ifndef _COORD_CRS_H
#define _COORD_CRS_H

#include "crs.h"
#include "coord_struct.h"

namespace SSLib {
  /**
   * @class coord_crs, contains an implementation of a 3-co-ordinate
   * based sparsematrix. It supports many of the operations suggested by the
   * abstract class sparsematrix. The format of the sparse matrix that is
   * loaded is as follows:
   * (i1, j1, val1)
   * (i1, j2, val2)
   * etc...note that file is ordered by row number ...
   */
  class coord_crs : public crs {
  public:
    virtual ~coord_crs() {
      // Free_up the data
    }

    virtual int load (const char*);
    virtual int load (const char*, bool asbin);
    virtual int load_txt (const char*);
    virtual int load_bin (const char*);
    virtual int load_matlab_fast(const char*);
    virtual int finish_load_matlab(FILE*);
    virtual int load_matlab_slow(const char*);
    virtual int load_matlab_gen(const char*);
    virtual int load_matlab_as_crs(FILE*);

    virtual void error(std::string);
  };
}

#endif // _COORD_CRS_H
