// File: coord_ccs_float.h -*- c++ -*-
// Time-stamp: <04 October 2006 05:24:48 PM CDT --  suvrit>
// Impl. of (i, j, val) type matrices, internally stored in CCS

#ifndef _COORD_CCSFLOAT_H
#define _COORD_CCSFLOAT_H

#include "ccs_float.h"
#include "coord_struct.h"

namespace SSLib {
  /**
   * @class coord_ccs, contains an implementation of a 3-co-ordinate
   * based sparsematrix. It supports many of the operations suggested by the
   * abstract class sparsematrix. The format of the sparse matrix that is
   * loaded is as follows:
   * (i1, j1, val1)
   * (i2, j1, val2)
   * etc...note that file is ordered by column number ...
   */
  class coord_ccs_float : public ccs_float {
  public:
    virtual ~coord_ccs_float() {
      // Free_up the data
    }

    /// Loads a general coordinate col sparse file, 
    virtual int load (const char*);
    virtual int load (const char*, bool asbin);
    virtual int load_txt (const char*);
    virtual int load_bin (const char*);
    virtual int load_matlab_fast(const char*);
    virtual int finish_load_matlab(FILE*);
    virtual int load_matlab_slow(const char*);
    virtual int load_matlab_gen(const char*);
    virtual int load_matlab_as_ccs(FILE*);
    virtual void error(std::string);
  };
}

#endif // _COORD_CCS_H
