// File: coord_ccs_compact.h -*- c++ -*-
// Time-stamp: <13 Februar 2008 06:08:06  CET --  suvrit>
// Impl. of (i, j, val) type matrices, internally stored in CCS

#ifndef _COORD_CCS_COMPACT_H
#define _COORD_CCS_COMPACT_H

#include "ccs_compact.h"
#include "coord_struct.h"

namespace SSLib {
  /**
   * @class coord_ccs_compact, contains an implementation of a 3-co-ordinate
   * based sparsematrix. It supports many of the operations suggested by the
   * abstract class sparsematrix. The format of the sparse matrix that is
   * loaded is as follows:
   * (i1, j1, val1)
   * (i2, j1, val2)
   * etc...note that file is ordered by column number ...
   * Also see the load_matlab_jiv function for support of the above format,
   * but for files stored in the format (j1, i1,v1), (j1, i2, v2), etc.
   *
   * NOTE: This is a compact class, so the maximum dimensionality of the
   * sparse matrix that is permitted is: USHRT_MAX x USHRT_MAX, which
   * translates to a 65536 x 65536 sparse matrix --- ideal for matrices that
   * deal with vectorization of (256 x 256) matrices.
   */
  class coord_ccs_compact : public ccs_compact {
  public:
    virtual ~coord_ccs() {
      // Free_up the data
    }

    /// Loads a general coordinate col sparse file, 
    virtual int load (const char*);
    virtual int load (const char*, bool asbin);
    virtual int load_txt (const char*);
    virtual int load_bin (const char*);
    virtual int load_matlab_fast(const char*);
    virtual int finish_load_matlab(FILE*);
    virtual int finish_load_matlab_jiv(FILE*);
    virtual int load_matlab_jiv(const char*);
    virtual int load_matlab_slow(const char*);
    virtual int load_matlab_gen(const char*);
    virtual int load_matlab_as_ccs(FILE*);
    virtual void error(std::string);
  };
}

#endif // _COORD_CCS_H
