// File: col_coord.h -*- c++ -*-
// Time-stamp: <01 March 2006 06:14:33 PM CST --  suvrit>
// Impl. of column coordinate format sparse matrices

#ifndef _COL_COORD_H
#define _COL_COORD_H

#include "crs.h"

namespace SSLib {
  /**
   * @class col_coord, contains an implementation of a column co-ordinate
   * based sparsematrix. It supports many of the operations suggested by the
   * abstract class sparsematrix. The format of the sparse matrix that is
   * loaded is as follows:
   * col1:val1 col2:val2 .... colk:valk
   * colx:valx coly:valy .... colj:valj
   * and so on...each line begins a new row of the matrix. If a row is
   * totally empty, then there should be a blank line in the file to
   * indicate that. The loaded matrix is stored internally as a CRS matrix.
   */
  class col_coord : public crs {
    
  public:
    virtual ~col_coord() {
      // Free_up the data
    }

    /// Load a coordinate sparse matrix with known dimensions
    virtual int load_fast (uint m, uint n, uint nz, const char*, 
                           int base = 0, char* separator = ":");

    /// Loads a general col coordinate sparse file, taking care of figuring
    /// out the number of rows, cols, nonzeros etc.
    virtual int load (const char*);
    virtual int load (const char*, bool asbin);

    virtual void error(std::string);
  };
}

#endif // _COL_COORD_H
