;; load sgml mode
(autoload 'sgml-mode "psgml" "Major mode to edit SGML files" t)

;; in sgml documents, parse dtd immediately to allow immediate
;; syntax coloring
(setq sgml-auto-activate-dtd t)

;; set the default SGML declaration. docbook.dcl should work for most DTDs
(setq sgml-declaration "/public2/linux/lib/sgml/dtd/docbook41/docbook.dcl")
      
;; here we set the syntax color information for psgml
(defun set-sgml-faces ()
  (interactive)
  "Set faces for SGML highlighting"
  (setq-default sgml-set-face t)
  (make-face 'sgml-comment-face)
  (make-face 'sgml-doctype-face)
  (make-face 'sgml-end-tag-face)
  (make-face 'sgml-entity-face)
  (make-face 'sgml-ignored-face)
  (make-face 'sgml-ms-end-face)
  (make-face 'sgml-ms-start-face)
  (make-face 'sgml-pi-face)
  (make-face 'sgml-sgml-face)
  (make-face 'sgml-short-ref-face)
  (make-face 'sgml-start-tag-face)
  (set-face-foreground 'sgml-comment-face "dark turquoise")
  (set-face-foreground 'sgml-doctype-face "red")
  (set-face-foreground 'sgml-end-tag-face "blue")
  (set-face-foreground 'sgml-entity-face "magenta")
  (set-face-foreground 'sgml-ignored-face "gray40")
  (set-face-background 'sgml-ignored-face "gray60")
  (set-face-foreground 'sgml-ms-end-face "green")
  (set-face-foreground 'sgml-ms-start-face "yellow")
  (set-face-foreground 'sgml-pi-face "lime green")
  (set-face-foreground 'sgml-sgml-face "brown")
  (set-face-foreground 'sgml-short-ref-face "deep sky blue")
  (set-face-foreground 'sgml-start-tag-face "dark green")
  
  (setq 
   sgml-markup-faces
   '((comment . sgml-comment-face)
     (doctype . sgml-doctype-face)
     (end-tag . sgml-end-tag-face)
     (entity . sgml-entity-face)
     (ignored . sgml-ignored-face)
     (ms-end . sgml-ms-end-face)
     (ms-start . sgml-ms-start-face)
     (pi . sgml-pi-face)
     (sgml . sgml-sgml-face)
     (short-ref . sgml-short-ref-face)
     (start-tag . sgml-start-tag-face))))
 
;; load xml-mode 
(setq auto-mode-alist
      (append (list (cons "\\.xml\\'" 'xml-mode))
	      auto-mode-alist))

(autoload 'xml-mode "psgml" nil t)
(setq sgml-xml-declaration
      "/public2/linux/lib/sgml/dtd/html/xml.dcl")


(setq-default sgml-indent-data t)
(setq
 sgml-always-quote-attributes   t
 sgml-auto-insert-required-elements t
 sgml-auto-activate-dtd         t
 sgml-indent-data               t
 sgml-indent-step               2
 sgml-minimize-attributes       nil
 sgml-omittag                   nil
 sgml-shorttag                  nil
 )
      
   
;; Start DTD mode for editing SGML-DTDs
(autoload 'dtd-mode "tdtd" "Major mode for SGML and XML DTDs.")
(autoload 'dtd-etags "tdtd"
"Execute etags on FILESPEC and match on DTD-specific regular expressions."
t)
(autoload 'dtd-grep "tdtd" "Grep for PATTERN in files matching FILESPEC." t)

(setq auto-mode-alist
(append
(list
'("\\.dcl$" . dtd-mode)
'("\\.dec$" . dtd-mode)
'("\\.dtd$" . dtd-mode)
'("\\.ele$" . dtd-mode)
'("\\.ent$" . dtd-mode)
'("\\.mod$" . dtd-mode))
auto-mode-alist))

;; the regexp for NTEmacs etags
(setq dtd-etags-regex-option
"--regex=\'/<!\\(ELEMENT\\|ENTITY[ \\t]+%\\|NOTATION\\|ATTLIST\\)[ \\t]+\\([^ \\t]+\\)/\\2/\'")
      ;; we need the NTEmacs etags, not the cygwin etags
      (setq dtd-etags-program "/usr/local/bin/etags.exe")
 
;; load psgml-jade extension
(setq
 sgml-command-list 
 (list 
  (list "Jade" "/usr/local/bin/openjade -c%catalogs -t%backend -d%stylesheet %file" 
	'sgml-run-command t
	'(("jade:\\(.*\\):\\(.*\\):\\(.*\\):E:" 1 2 3)))
  (list "JadeTeX" "jadetex %tex" 
	'sgml-run-command nil)
  (list "JadeTeX PDF" "pdfjadetex %tex"
	'sgml-run-command t)
  (list "dvips" "dvips -o %ps %dvi"
	'sgml-run-command nil)
  (list "View dvi" "yap %dvi" 
	'sgml-run-background t)
  (list "View PDF" "explorer %pdf" 
	'sgml-run-command nil)
  (list "View ps" "gs %ps"
	'sgml-run-command nil))
 )

(setq sgml-sgml-file-extension "sgml")

(setq sgml-dsssl-file-extension "dsl")

(setq 
 sgml-expand-list 
 (list 
  (list "%file" 'file nil)     ; the current file as is
  (list "%sgml" 'file sgml-sgml-file-extension) ;   with given extension
  (list "%tex" 'file "tex")        ;   dito 
  (list "%dvi" 'file "dvi")        ;   dito
  (list "%pdf" 'file "pdf")        ;   dito
  (list "%ps" 'file "ps")      ;   dito
  (list "%dsssl" 'file sgml-dsssl-file-extension) ;   dito
  (list "%dir" 'file nil t)        ; the directory part  
  (list "%stylesheet" 'sgml-dsssl-spec) ; the specified style sheet
  (list "%backend" 'sgml-jade-backend) ; the selected backend
  (list "%catalogs" 'sgml-dsssl-catalogs 'sgml-catalog-files 'sgml-local-catalogs)
  ; the catalogs listed in sgml-catalog-files and sgml-local-catalogs.
  )
 )

(setq sgml-shell "sh")
(setq sgml-shell-flag "-c")
(add-hook 'sgml-mode-hook '(lambda () (require 'psgml-jade)))
;(add-hook 'sgml-mode-hook 'set-sgml-faces)
;; load dsssl support
(autoload 'sgml-dsssl-make-spec "psgml-dsssl" nil t)

;; PSGML menus for creating new documents
(setq sgml-custom-dtd
'(
  ( "HTML 2.0"
    "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">")
  ( "HTML 2.0 Strict"
    "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0 Strict//EN\">")
  ( "HTML 2.0 Level 1"
    "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0 Strict Level 1//EN\">")
  ( "HTML 3.2 Final"
    "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\">")
  ( "HTML 4"
    "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\">")
  ( "HTML 4 Frameset"
    "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Frameset//EN\">")
  ( "HTML 4 Transitional"
    "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">")
  ( "DocBook 4.1"
   "<!DOCTYPE Book PUBLIC \"-//OASIS//DTD DocBook V4.1//EN\">")
  ( "XHTML 1.0"
    "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\">")
  ( "XHTML 1.0 Transitional"
    "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\">")
  ( "XHTML 1.0 Frameset"
    "<!DOCTYPE HTML PUBLIC \"//W3C//DTD XHTML 1.0 Frameset//EN\">")
  )
)


;(setq 
; sgml-ecat-files 
; (list
;  (expand-file-name "/public2/linux/lib/sgml/dtd/html/ecatalog")
;  (expand-file-name "c:/cygwin/usr/local/lib/sgml/dtd/docbook41/ecatalog")
;  (expand-file-name "/public2/linux/lib/sgml/dtd/xhtml/ecatalog")
;  ))


