// -*- c++ -*-
#ifndef UTIL_H
#define UTIL_H

#include <gsl/gsl_matrix.h>
#include <gsl/gsl_rng.h>
#include <ostream>


gsl_matrix* read_gsl_matrix(char* filename);
gsl_matrix* read_gsl_matrix_fortran(char* filename);
int         fread_gsl_matrix_fortan(char*);
int         read_gsl_matrix(gsl_matrix*, char*);
int         fread_gsl_matrix(gsl_matrix*, char* f);
int         write_gsl_matrix(gsl_matrix* m, char* f);
int         printon(gsl_matrix*, std::ostream&);
gsl_matrix* random_matrix(int m, int n);
//int         normalize_matrix_cols(gsl_matrix*, Norm*);
//int         normalize_matrix_rows(gsl_matrix*, Norm*);
int         gsl_matrix_to_pgms(gsl_matrix*, char*, int r, int c, int scale);
int         fwrite_gsl_matrix(gsl_matrix*, const char*);
int         fwrite_gsl_matrix(gsl_matrix*, FILE*);
gsl_matrix* fread_gsl_matrix(char* file);
gsl_matrix* fread_gsl_matrix(FILE*);
void        gsl_to_sparse(gsl_matrix*, char* prefix);
long        nnzero(gsl_matrix*);

gsl_matrix* prepare_for_clapack(gsl_matrix*);
gsl_matrix* clapack_to_c (double*);

double      fnorm(gsl_matrix*);
#endif
