// File: s_sis2.h  -*- c++ -*-
// Author: Suvrit Sra
// Date: 12 Nov, 2003


#ifndef _S_SIS2_H_
#define _S_SIS2_H_

#include "sis.h"

/****************************************************************
 * Sparse SVD Via Subspace Iteraton Procedure for Equivalent    *
 * 2-Cyclic and A'A Eigensystems.                               *
 *                                                              *
 ****************************************************************/

namespace ssvd {

class s_sis2 : public sis {
protected:
  void intros(FILE*, long ks, long kg, long kh, double *f, long m);
  void mopb(long n,double *x, double *y);
  void opa(long n,double *x, double *y);
public:
  // Taken from sis2.c
  void   ritzit(FILE*, long, long, long, double ,long , double **, double *,
		double *, double *, double *, long *);

  virtual int    runIt() = 0;
  virtual double* getU() = 0;
  virtual double* getV() = 0;

};

}
#endif
