// File: s_opts.h -*- c++ -*-
// Author: Suvrit Sra
// Date: 23 Nov, 2003

// Provides an interface to the various options that the various svd routines can take


#ifndef _S_OPTIONS_H_
#define _S_OPTIONS_H_

#include <cstdio>
#include <SparseMatrix.h>

namespace ssvd {

struct OptionsStruct { 
  char prefix[1024];		/* file name prefix */
  char txx[6];			/* txx or tfn or whatever */
  char out1[256];		/* Output file for statistics */
  char out2[256];		/* Output file for singular vecs, etc. */
  char out3[256];
  char name[256];		/* Problem file name */
  long  maxsubsp;		/* Max subspace size */
  char vtf[10];
  long  nums;			/* Num of singular triplets desired */
  long km;
  bool vectors;			/* Singular vectors desired */
  double tol;			/* Tolerance for accuracy */
  long  maxit;			/* Max num. of iterations */
  long  numextra;		/* Num. of extra dim. to carry along */
  long  accel;			/* Type of acceleration (for tms[1-2]) */
  double red;			/* Tolerance for residual reduction, tms.. */
  long  lanmax;			/* Max. num of Lanzcos iterations */
  double  endl, endr;		/* Integers, end pointers */
  double kappa;			/* For las1, las2 rel. acc. of Ritz values */
  long nc, nb;			/* For bls1, bls2 */
  FILE *in1;		        /* optionsfile pointer */
  FILE *of1, *of2;
  long fpo2;
  FILE* vecs;			/* Singular vectors in a text file */
  bool  ascii;			/* For above file.. */
  double eps;
  SparseMatrix* sA;		/* External sparse matrix if any */

  int dofiles;         /* do file io or not*/
  int verbose;                  // level of verbosity.
  OptionsStruct() { sA = 0; vecs = 0; ascii = false; dofiles = false;}
  void setFromFile(int, char*);	/* Read options from type of file and do it*/
};

}
#endif // _S_OPTIONS_H_
