// bls.h -- base class for bls algorithms -*- c++ -*-
// Author: Suvrit Sra
// Date: 14 nov, 2003


#ifndef _S_BLS_BASE_H
#define _S_BLS_BASE_H

#include "svdpack.h"

namespace ssvd {
/***************************************************************
 * Sparse SVD Via Hybrid Block Lanczos Procedure for Equivalent *
 * 2-Cyclic Eigensystems.                                       *
 *                                                              *
 * Global variables and common areas used by bls1 and its       *
 * functions.                                                   *
 ****************************************************************/
class bls : public svdpack {
protected:
  static const int CONTINUE = 1;
  static const int DONE = 0;
  
  char* error[8];


  long validate(FILE*, long, long, long, long, long, long, double);
  void formbigs(long, long, double **, double **, double **);
public:
  bls() : svdpack()
  {
    error[0] = "";
    error[1] = " ***** SORRY, YOUR MATRIX IS TOO BIG *****";
    error[2] = " ***** NCOL MUST NOT BE GREATER THAN NROW *****";
    error[3] = " ***** TOLERANCE IS INVALID *****";
    error[4] = " ***** MAXIMUM SUBSPACE DIMENSION IS INVALID *****";
    error[5] = " ***** INITIAL BLOCK SIZE MUST BE GREATER THAN 1 *****";
    error[6] = " ***** NUMBER OF SINGULAR VALUES DESIRED IS INVALID *****";
    error[7] = " ***** INIT BLK SIZE MUST BE LESS THAN NO. OF S-VALUES DESIRED *****";
  }
  bls(long nm, long nz, long sd) : svdpack(nm, nz, sd) {}
};

}

#endif 
