// File: blas.h
// Author: Suvrit Sra
// has the common blas routines used by svdpack

/* Blas routines, replace them by using <clapack.h> */
  double  dasum  (long, double *, long                       );  
  void    datx   (long, double, double *,long, double *, long);
void    daxpy  (long, double, double *,long, double *, long);

void    dcopy  (long n,double *dx,long incx,double *dy,
                long incy                                  );
double  ddot   (long, double *,long, double *, long        );

void    dgemm  (long, long, long, long, long, double, 
                double **, double *, double, double *      );
void    dgemm2 (long, long, long, long, long, double, 
                double **, double **, double, double **    );
void    dgemm3 (long, long, long, long, long, double,
                double **, long, long, double **, long,
                long, double, double **, long, long        );

void    dgemv  (long, long, long, double, double **,
                double *, double, double *                 );
void    dgemv2 (long, long, long, double, double **, long,
                long, double *, double, double *           );

double  dmax   (double, double                             );
double  dmin   (double, double                             );

void    drot   (long, double *, double *, double, double   );
void    drotg  (double *, double *, double *, double *     );

void    dscal  (long, double, double *,long                );
void    dsbmv  (long, long, double, double **, 
                double *, double, double *                 );
void    dsort2 (long,long, double *, double *              );
void    dswap  (long, double *, long, double *, long       );
void    dtbmv  (long, long, long, double **, double *      );

double  enorm  (long, double *                             );
double  fsign  (double , double                            );


long    imin   (long, long                                 );
long    imax   (long, long                                 );
void    imtql2 (long, long, double *, double *, double *   );

double  mrandom(long *                                     );
double  norm_1 ();
void    opa    (double *, double *                         );
void    opa    (long, long, double *, double *             );
void    opat   (double *,double *                          );
void    opat   (long, double *, double *                   );

void    opb    (long, double *, double *                   );
void    opb    (long, double *, double *, bool             );
void    opb    (long, long, double *, double *             );
//void    opb    (long, double *, double *, double           );
void    opm    (long, long, long, double **, double **     );

void    orthg  (long, long, long, double **, double **, 
                double *                                   );  
double  pythag (double, double                             );
void    qriter2(long, double *, double *, double **,
                double **                                  );


long    tql2   (long, long, double *, double *, double **  );
long    tql2   (long, double*, double*, double**           );
void    tred2  (long, long, double **, double *,
                double *, double **                        );

