// -*- c++ -*-
// mynnls.h: Header file for non negative least squares.
// Copyright (C) 2003 Suvrit Sra

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#ifndef MYNNLS_H
#define MYNNLS_H

#include <gsl/gsl_matrix.h>
#include <gsl/gsl_vector.h>
#include <gsl/gsl_blas.h>


/**
 * NNLS: Based on the lawson-hanson nnls algorithm. It performs NNLS for
 * multiple right hand sides. I.e. Find the matrix X >= 0 such that
 * ||AX - B|| is minimized (Frobenius norm).
 *
 * Input: A: The matrix A
 *           B = [b1 b2 ... br] -- r different right hand sides
 *
 * Output:  X = [x1 x2 ... xr] -- r vectors x_i such that ||Ax_i-b_i|| is
 *          minimized and x_i >= 0
 *
 * Note:
 * Author: Suvrit Sra (suvrit@cs.utexas.edu)
 *
 */

int mynnls(gsl_matrix* A, gsl_matrix* X, gsl_matrix* B, int** P, int** Z);
int gsl_my_matrix_sub(const gsl_matrix*, const gsl_matrix*, gsl_matrix*);
bool isEmpty(int* z, int sz);

#endif
