// -*- c++ -*-
#ifndef SPARSEVECTOR_H
#define SPARSEVECTOR_H

#include <algorithm>
#include <iostream>

using namespace std;

class SparseVector {
  int* m_idx;
  double* m_val;
  int m_nz;
  bool isExternal;
  int m_rows;
public:
  SparseVector(int r, int nz) : m_rows(r), m_nz(nz)
  {
    if (r <= 0 or nz <= 0 or (nz > r)) {
      cerr << "Bad stuff in sparsevector constructor\n";
    }
    m_idx = new int[nz];
    m_val = new double[nz];
    isExternal = false;
  }

  SparseVector(int r, int nz, int* idx, double* v) : m_rows(r), m_nz(nz) {
    m_val = v;
    for (int i = 0; i < nz; i++)
      m_idx[i] = idx[i];
  }

  inline double operator() (int i) {
    int pos = -1;

    // NOTE:
    // Replace the following by binary search that tells us the position at
    // which object was found.
    for (int r = 0; r < m_rows; r++) {
      if (m_idx[r] == i) {
	pos = r;
	break;
      }
    }
    if (pos != -1)
      return m_val[pos];
    return 0.0;
  }

};

#endif



