// -*- c++ -*-
// FactorizationSFrob.h -- class for Lee/Seung Frob on Sparse
// Copyright (C) 2003 Suvrit Sra (suvrit@cs.utexas.edu)

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#ifndef FACTORIZATIONSFROB_H
#define FACTORIZATIONSFROB_H

#include "FactorizationS.h"

/**
 * This class implements the sparse version of the NMF algo of Lee/Seung.
 * Author: Suvrit Sra
 * Creation: 3/25/03
 */
class FactorizationSFrob : public FactorizationS {
public:
  FactorizationSFrob(DriverOpts* o) : FactorizationS(o) {}
  FactorizationSFrob(int rank, int maxiter, double eps, SparseMatrix* a,
		     bool ve, unsigned long int s, int om, char* vh, bool no) :
    FactorizationS(rank, maxiter, eps, a, ve, s, om, vh, no) 
  {}
  int perform();
  virtual ~FactorizationSFrob() { }
  double compute_objonly(char*);
};

#endif
