// -*- c++ -*-
// FactorizationS.h -- base class for factorizations of sparse matrices. 
// Copyright (C) 2003 Suvrit Sra (suvrit@cs.utexas.edu)

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#ifndef FACTORIZATIONS_H
#define FACTORIZATIONS_H


#include "Factorization.h"
#include "SparseMatrix.h"

/**
 * Base class for factorizations using sparse algos.
 */
class FactorizationS : public Factorization {
protected:
  SparseMatrix* sA;
public:
  FactorizationS(DriverOpts* o) : Factorization(o)
  {
    sA = o->sA;
    V = gsl_matrix_alloc(sA->numRows(), o->rank);
    H = gsl_matrix_alloc(o->rank, sA->numCols());
  }

  FactorizationS(int rank, int miter, double e, SparseMatrix* a,
		 bool ve, unsigned long int s, int om, char* vh, bool no) :
    Factorization(rank, miter, e, ve, s, om, vh, no), sA(a)
  {
    V = gsl_matrix_alloc(sA->numRows(), rank);
    H = gsl_matrix_alloc(rank, sA->numCols());
  }

  virtual bool checkRank() {
    return (getRank() <= std::min (sA->numRows(), sA->numCols()));
  }

  virtual double compute_objonly(char*) = 0;
  virtual ~FactorizationS()
  {
    gsl_matrix_free(V);
    V = 0;
    gsl_matrix_free(H);
    H = 0;
  }
};

#endif
