// FactorizationHybrid.h  -*- c++ -*-
// Copyright (C) 2003 Suvrit Sra (suvrit@cs.utexas.edu)

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#ifndef FACTORIZATIONHYBRID_H
#define FACTORIZATIONHYBRID_H

#include "Factorization.h"

// Extends factorization
class FactorizationHybrid : public Factorization {
  double compute_obj(const gsl_matrix*);
  int nnlsiter;
  int frobiter;
  gsl_matrix* P;
public:
  FactorizationHybrid(DriverOpts* o) : Factorization(o) 
  {
    nnlsiter = o->maxiter/10 + 1;
    frobiter = o->maxiter - nnlsiter;
  }
  FactorizationHybrid(int rank, int maxiter, double eps, gsl_matrix* a, 
		      bool ve, unsigned long int s, int om, char* vh, bool no) :
    Factorization(rank, maxiter, eps, a, ve, s, om, vh, no) {nnlsiter = maxiter/10+1; frobiter = maxiter-nnlsiter;}
  int perform();
  double performnnls(int);
  double performfrob(int);
  double getObjVal() const { return objval;}
  virtual ~FactorizationHybrid() { }
  double compute_objonly(char*);
  int  getnnlsiter() const { return nnlsiter;}
  void setnnlsiter(int i) { 
    nnlsiter = i;
    if (i >= getMaxiter()) nnlsiter = getMaxiter();
    frobiter = getMaxiter() - nnlsiter;
  }
};


#endif
