// -*- c++ -*-
// FactorizationFrobWt2.h -- base class for weighted Lee/Seung style
// Frob. algorithm -- for left and right matrix scaling.
// Copyright (C) 2003 Suvrit Sra (suvrit@cs.utexas.edu)

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#ifndef FACTORIZATIONFROB_WT2_H
#define FACTORIZATIONFROB_WT2_H

#include "Factorization.h"

// Extends factorization
class FactorizationFrobWt2 : public Factorization {
  double compute_obj(const gsl_matrix*);
  gsl_matrix* L;
  gsl_matrix* R;
  gsl_matrix* LtL;
  gsl_matrix* RRt;
  gsl_matrix* Ah;		// copy of A
  char* lfile;
  char* rfile;
  
public:
  FactorizationFrobWt2(DriverOpts* o) : Factorization(o) 
  {L = 0; R = 0; lfile = o->wtLfile; rfile = o->wtRfile;}

  FactorizationFrobWt2(int rank, int maxiter, double eps, gsl_matrix* a, 
		    bool ve, unsigned long int s, int om, char* vh, bool no) :
    Factorization(rank, maxiter, eps, a, ve, s, om, vh, no) {L = 0; R = 0;}
  int perform();
  double getObjVal() const { return objval;}
  virtual ~FactorizationFrobWt2() { }
  double compute_objonly(char*);
};

#endif
