// -*- c++ -*-
// FactorizationFrobSlow.h -- base class for Lee/Seung Frob. algo.
// Copyright (C) 2003-2004 Suvrit Sra (suvrit@cs.utexas.edu)

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#ifndef FACTORIZATIONFROB_SLOW_H
#define FACTORIZATIONFROB_SLOW_H

#include "Factorization.h"

// Extends factorization
class FactorizationFrobSlow : public Factorization {
    double compute_obj(const gsl_matrix*);
public:
  FactorizationFrobSlow(DriverOpts* o) : Factorization(o) {}
  FactorizationFrobSlow(int rank, int maxiter, double eps, gsl_matrix* a, 
		    bool ve, unsigned long int s, int om, char* vh, bool no) :
    Factorization(rank, maxiter, eps, a, ve, s, om, vh, no) {}
  int perform();
  double getObjVal() const { return objval;}
  virtual ~FactorizationFrobSlow() { }
  double compute_objonly(char*);
};

#endif
