// -*- c++ -*-
// FactorizationBreg2.h -- base class for bregman div. min algo.
// Copyright (C) 2004 Suvrit Sra (suvrit@cs.utexas.edu)

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#ifndef FACTORIZATIONBREG2_H
#define FACTORIZATIONBREG2_H

#include "Factorization.h"

// Extends factorization
class FactorizationBreg2 : public Factorization {
    double compute_obj(const gsl_matrix*);
    double (*phi) (double);	/* \phi */
    double (*psi) (double);	/* d\phi */
    int phizetaset;
public:
  FactorizationBreg2(DriverOpts* o) : Factorization(o) {phizetaset = 0;}
  FactorizationBreg2(int rank, int maxiter, double eps, gsl_matrix* a, 
		    bool ve, unsigned long int s, int om, char* vh, bool no) :
    Factorization(rank, maxiter, eps, a, ve, s, om, vh, no) {phizetaset = 0;}
  int doPerform();
  double getObjVal() const { return objval;}
  virtual ~FactorizationBreg2() { }
  void setPhi  (double (*f)(double)) { phi  = f; phizetaset++;}
  void setPsi  (double (*f)(double)) { psi  = f; phizetaset++;} 
  double compute_objonly(char*);
};

#endif
