// -*- c++ -*-
// FactorizationAKL.h -- header for alternating KL algorithm
// Copyright (C) 2003 Suvrit Sra (suvrit@cs.utexas.edu)

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.



#ifndef FACTORIZATIONAKL_H
#define FACTORIZATIONAKL_H

#include "Factorization.h"

// Extends factorization
class FactorizationAKL : public Factorization {
public:
  FactorizationAKL(DriverOpts* o) : Factorization(o) {}
  FactorizationAKL(int r, int m, double e, gsl_matrix* a,
		    bool v, unsigned long int s, int om, char* vh, bool no) :
    Factorization(r, m, e, a, v, s, om, vh, no)  {}
  int perform();
  double compute_obj(const gsl_matrix*);
  virtual ~FactorizationAKL() {}
  double compute_objonly(char*);
};




#endif
