// 	$Id: Matrix.cc,v 1.1.1.1 2003/04/02 22:06:19 suvrit Exp $	

// Matrix. template class...(abandoned..)
// Copyright (C) 2003 Suvrit Sra (suvrit@cs.utexas.edu)

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#include "Matrix.h"

double fnorm(Matrix& A)
{
    double no = 0.0;
    for (int i = 0; i < A.nrows(); i++)
	for (int j = 0; j < A.ncols(); j++) {
	    double t = A(i,j);
	    no += t*t;
	}
    return sqrt(no);
}

#if 0


// Forced init need for removing linking errors ...
template class Matrix<double>;

template <class T>
Matrix<T>* Matrix<T>::operator + (Matrix<T>* B)
{
    if (numRows() != B->numRows() || numCols() != B->numCols())
	throw MatrixExceptionSize("Incompatible dimensions, add");
    Matrix<T>* result = new Matrix<T>(B->numRows(), B->numCols());
    for (int i = 0; i < numRows(); i++)
	for (int j = 0; j < numCols(); j++)
	    result->set(i,j, data[i][j]+B->get(i,j));
    return result;
}


template <class T>
Matrix<T>* Matrix<T>::operator - (Matrix<T>* B)
{
    if (numRows() != B->numRows() || numCols() != B->numCols())
	throw MatrixExceptionSize("Incompatible dimensions, subr");
    Matrix<T>* result = new Matrix<T>(B->numRows(), B->numCols());
    for (int i = 0; i < numRows(); i++)
	for (int j = 0; j < numCols(); j++)
	    result->set(i,j, data[i][j]-B->get(i,j));
    return result;
}


template <class T>
Matrix<T>* Matrix<T>::operator * (Matrix<T>* B)
{
    if (numCols() != B->numRows())
	throw MatrixExceptionSize("Incompatible dim for mpy");
    T sum;
    Matrix<T>* prod = new Matrix<T>(numRows(), B->numCols());

    for (int i = 0; i < numRows(); i++) {
	for (int j = 0; j < B->numCols(); j++) {
	    sum = 0;
	    for (int k = 0; k < numCols(); k++)
		sum += data[i][k] * B->get(k,j);
	    prod->set(i,j,sum);
	}
    }
    return prod;
}

template <class T>
T& Matrix<T>::operator () (int i, int j)
{
     return data[i][j];
}

template <class T>
void Matrix<T>::set(int i, int j, T val)
{
    data[i][j] = val;
}

template <class T>
void Matrix<T>::print(ostream& os)
{
    if (m_rows == 0 || m_cols == 0)
	return;
    os << m_rows << " " << m_cols << endl;
    for (int i = 0; i < m_rows; i++) {
	for (int j = 0; j < m_cols; j++)
	    os << data[i][j] << " ";
	os << endl;
    }
}

#endif // Entire file excluded as of now
