// File: DriverOpts.cc 
// Author: Suvrit Sra
// Date: 03 Dec 03

// Some simple utility functions for DriverOpts structs.

// Copyright (C) 2003 Suvrit Sra (suvrit@cs.utexas.edu)

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#include "DriverOpts.h"


std::ostream& operator << (std::ostream& os, DriverOpts& o) {
  os << "Dataset ==>\t"   << o.fname << "\n"
     << "Scaling ==>\t"   << o.txx << "\n"
     << "Algo    ==>\t"   << o.algoname << "\n"
     << "Epsilon ==>\t"   << o.epsilon << "\n"
     << "Maxiter ==>\t"   << o.maxiter << "\n"
     << "RanSeed ==>\t"   << o.rseed << "\n"
     << "Rank    ==>\t"   << o.rank << "\n"
     << "Sparse  ==>\t"   << o.sparse << "\n"
     << "Objmodu ==>\t"   << o.objmodulo << "\n"
     << "Do Svd  ==>\t"   << o.dosvd << "\n"
     << "Slowobj ==>\t"   << o.slowobj << "\n"
     << "Binfile ==>\t"   << o.binfile << "\n"
     << "Normalz ==>\t"   << o.normalize << "\n"
     << "Init.   ==>\t"   << (o.vhprefix ? o.vhprefix : "Random") << "\n";
  
  return os;
}
