/* File: svdbase.h   -*- c++ -*- */
/* Author: Suvrit Sra */
/* (c) 2007 Suvrit Sra */
/* Max-Planck Institute for biological Cybernetics */
/* Tuebingen, Germany */

/* This program is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* This program is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to the Free Software */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */

#ifndef _SVDBASE_H_
#define _SVDBASE_H_

#include <sys/types.h>
#include <climits>
#include <cstdio>

#include "options.h"

#ifdef __cplusplus
#  define BEGIN_C_DECLS extern "C" {
#  define END_C_DECLS   }
#else /* !__cplusplus */
#  define BEGIN_C_DECLS
#  define END_C_DECLS
#endif /* __cplusplus */


BEGIN_C_DECLS

#include "blas.h"

END_C_DECLS

namespace mysvd {
  class svdbase {
  protected:
    /* Shared constant values among all derived classes */
    static const int MINBLKS;  
    static const int TRANSP;
    static const int NTRANSP;
    static const int TRUE;
    static const int FALSE;
    static const double CONST; 
    static const double ZERO;  
    static const double ONE;
    static const double RDWARF;
    static const double RGIANT;

    char* error[100];
    /* Standard params restricting input size etc.*/
    size_t NZMAX;
    size_t NCMAX;
    long int SEED;
    size_t LMTNW;
    size_t TB;

    /* More common variables */
    int    mxvcount;              /* matrix-vector multiplications counter */ 
    int    mtxvcount;             /* transposed matrix-vector mult. counter*/
    int    iconv;                 /* converged vector counter              */
    long   ierr;                  // 
    long j;                     /* number of lanczos steps taken      */
    size_t neig;                /* number of ritz values stabilized   */
    size_t nsig;                /* number of accepted ritz values     *
                                 * based on kappa (relative accuracy) */
    
    size_t ncol;                /* number of columns of A	       */
    size_t nrow;                /* number of rows of A		       */
    size_t nnz;                 /* number of non zeros in A           */
    

    OptionsStruct* options;

    int verbose;
    // METHODS:

    void    write_header(long, FILE*, bool, size_t, size_t, int, char*);
    double timer();

    void setsize(size_t m, size_t n, size_t z) 
    { nrow = m; ncol = n; nnz = z;}
    
  public:
    svdbase() {
      mxvcount = mtxvcount = ierr = 0; 
      //// !!!!! FIX ME !!!!!
# if __WORDSIZE == 64
      TB    = 1024L*1024L*1024L*1024L;
# else
      TB    = 1024*1024*100L;
# endif
      NCMAX = 10*TB;          // max num. of columns ...
      NZMAX = 20*TB;          // max num. of nonzeros ...
      SEED  = 91827211L; 
      LMTNW = 20*TB;          // max workspace 
    }

    virtual ~svdbase() {}
    virtual int run() = 0;
  };
}
#endif // _SVDBASE_H_
