// File: svdbase.cc
// Author: Suvrit Sra
// Time-stamp: <19 February 2010 03:27:45 PM CET --  suvrit>

#include <cstdio>
#include <sys/time.h>
#include <sys/resource.h>

#include "svdbase.h"

using namespace mysvd;

const int svdbase::MINBLKS  =  2;
const int svdbase::TRANSP   =  1;
const int svdbase::NTRANSP  =  0;
const int svdbase::TRUE     =  1;
const int svdbase::FALSE    =  0;
const double svdbase::CONST =  100.0;
const double svdbase::ZERO  =  0.0;
const double svdbase::ONE   =  1.0;
const double svdbase::RDWARF=  3.834e-20;
const double svdbase::RGIANT=  1.304e19;

double svdbase::timer()
{
  
  long elapsed_time;
  struct rusage mytime;
  getrusage(RUSAGE_SELF,&mytime);
  
  /* convert elapsed time to milliseconds */
  elapsed_time = (mytime.ru_utime.tv_sec * 1000 + 
		  mytime.ru_utime.tv_usec / 1000);
  
  /* return elapsed time in seconds */
  return elapsed_time/1000.;
}

void svdbase::write_header(long rfp, FILE* fp, bool ascii, size_t m, size_t n, int k, char* algo)
{
  ssize_t r;
  if (ascii) {
    fprintf(fp, "%zu %zu %d %s\n", m, n, k, algo);
  } else {
    r=write(rfp, (char *)&m, sizeof(m));
    r=write(rfp, (char *)&n, sizeof(n));
    r=write(rfp, (char *)&k, sizeof(k));
    r=write(rfp, algo, 5);
    //    write(rfp, (char*)&nsig, sizeof(nsig));
  }
}
