// File: options.h -*- c++ -*-
// Author: Suvrit Sra
// Date: 23 Nov, 2003

// Time-stamp: <19 February 2010 03:06:37 PM CET --  suvrit>
// Provides an interface to the various options that the various svd routines can take


#ifndef _S_OPTIONS_H_
#define _S_OPTIONS_H_

#include <cstdio>
#include "SparseMatrix.h"

struct OptionsStruct { 
  char matrix_file[251];		/* file name prefix */
  char valfile[256];		/* Output file for statistics */
  char vecfile[256];		/* Output file for singular vecs, etc. */
  char buf[256];		/* Problem file name */
  size_t  nums;			/* Num of singular triplets desired */
  bool vectors;			/* Singular vectors desired */
  double tol;			/* Tolerance for accuracy */
  long  maxit;			/* Max num. of iterations */
  long  numextra;		/* Num. of extra dim. to carry along */
  long  accel;			/* Type of acceleration (for tms[1-2]) */
  double red;			/* Tolerance for residual reduction, tms.. */
  size_t  lanmax;			/* Max. num of Lanzcos iterations */
  double  endl, endr;		/* Integers, end pointers */
  double kappa;			/* For las1, las2 rel. acc. of Ritz values */
  long nc, nb;			/* For bls1, bls2 */

  FILE *ofp;		        /* optionsfile pointer */
  FILE* valfp;
  FILE* msgfp;
  FILE* vecs;			/* Singular vectors in a text file */
  long vecfp;

  bool  ascii;			/* For above file.. */
  bool data_is_bin;             /* If matrix_file shd. be loaded as binary */
  int  data_typ;                /* Type of matrix */
  double eps;
  SparseMatrix<double>* dA;		/* External sparse matrix if any */
  SparseMatrix<float>* sA;
  int verbose;                  // level of verbosity.
public:
  OptionsStruct() { dA = 0; sA = 0; verbose = 1;}
  void setFromFile(int, char*);	/* Read options from type of file and do it*/
  void set_verbosity(int v) { verbose = v;}
  int  get_verbosity()  const {return verbose;}
};

#endif // _S_OPTIONS_H_
