// File: main.cc -- skeleton for invoking the sparse svd driver
// Author: Suvrit Sra
// Date: 16, Nov 2003
// Time-stamp: <04 Dezember 2007 05:02:57  CET --  suvrit>

// (c) Suvrit Sra 2004 All Rights Reserved

#include "dlas1.h"
#include "dlas2.h"

void show_help();

int main(int argc, char** argv)
{
  mysvd::dsvd* svd;
  int r = 0;

  if (argc < 2) {
    show_help();
    return -1;
  }

  if (argc == 2)
    svd = new mysvd::dlas2();

  if (argc == 3 && atoi(argv[1]) == 1)
    svd = new mysvd::dlas1();
  else
    svd = new mysvd::dlas2();

  if ( (r = svd->read_options_fromfile(argv[ argc == 2 ? 1 : 2])) < 0)
    return r;

  return svd->run();
}

void show_help()
{
  std::cerr << "Usage: svd [AlGO] <options_file>\n"
            << "svd 1 <options_file> calls LAS1\n"
            << "svd 2 <options_file> calls LAS2\n";

}
