/* dsvd.h -- double precision interface to SVDPACK   -*- c++ -*-
   Copyright (C) 2003 Suvrit Sra (suvrit@cs.utexas.edu) */

/* This program is free software; you can redistribute it and/or */
/* modify it under the terms of the GNU General Public License */
/* as published by the Free Software Foundation; either version 2 */
/* of the License, or (at your option) any later version. */

/* This program is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to the Free Software */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */

#ifndef _DSVDPACK_H
#define _DSVDPACK_H

#include "svdbase.h"
#include "SparseMatrix.h"

#include "blas.h"
#include "options.h"

namespace mysvd {
  class dsvd : public svdbase  {
  protected:
    
    /* Common variables for all types of svd subclasses      */
    size_t *pointr;               /* pointer to column start array         */
    size_t *rowind;               /* pointer to row indices array          */
    double  *value;               /* pointer to nonzero values array       */
  
    double  *sing;                 /* singular values are filled into this */

    double *alpha,         /* diagonal elements of bidiagonal matrix*
                            * from single vector Lanczos (inner)    *
                            * recursion                             */
      *beta,          /* super-diagonals of bidiagonal matrix  *
                       * from single vector Lanczos (inner)    *
                       * recursion                             */
      *p,             /* work array                            */
      *q,             /* work array                            */
      *t,             /* work array                            */
      *z;             /* work array                            */
    double *tres,          /* temporary residual array              */
      *y,             /* work array                            */
      *temp,          /* temporary work space                  */
      *uu,            /* work array                            */
      *vv,            /* work array                            */
      *u0,            /* array of converged left S-vectors     */
      *v0,            /* array of converged right S-vectors    */
      *uvtmp,         /* temporary work space                  */
      *pp,            /* left S-vectors of block upper bi-     *
                       * diagonal matrix from outer recursion  */ 
      *qq;            /* right S-vectors of block upper bi-    *
                       * diagonal matrix from outer recursion  */

    double *xv1,           /* temp arrays needed for computing   */
      *xv2,           /* singular vectors		       */
      *a;	         /* pointer to area used by user-      *
                      * supplied procedure store and holds *
                      * lanczos vectors 		       */

    /* Copied from las1.h */
    double  rnm,		 /* norm of the next residual vector   */
      anorm,
	  tol,
	  eps,		 /* positive machine epsilon	      */
	  eps1,		 /* roundoff estimate for dot product  *
                  * of two unit vector		      */
	  reps,
	  eps34;
    
    double  *ztemp;
    double* U;
    double* V;
    
    long iter, nn;
    
    double   mrandom(long *                                     );
    double   norm_1 ();
    void    opa    (double *, double *                         );
    void    opa    (long, long, double *, double *             );
    void    opat   (double *,double *                          );
    void    opat   (long, double *, double *                   );

    void    opb    (long, double *, double *                   );
    void    opb    (long, double *, double *, bool             );
    void    opb    (long, long, double *, double *             );
    //void    opb    (long, double *, double *, double           );
    void    opm    (long, long, long, double **, double **     );
    void mopb(long n, double *x, double *y);
    void mopa(double *x, double *y);
    void    orthg  (long, long, long, double **, double **, 
                    double *                                   );  
    void    qriter2(long, double *, double *, double **,
                    double **                                  );


    long    tql2   (long, long, double *, double *, double **  );
    long    tql2   (long, double*, double*, double**           );
    void    tred2  (long, long, double **, double *,
                    double *, double **                        );

    double  fsign  (double , double                            );
    void imtql2(long nm, long n, double d[], double e[], double z[]);
    void dsort2(long igap,long n,double *array1,double *array2);
    void datx(long n,double da,double *dx,long incx,double *dy,long incy);
    double pythag(double a, double b);

    int dcomp(double* a, double* b);
    void   cleanup() { /* deallocate stuff etc. */ }	
    void setptrs(size_t* cp, size_t* ri, double* va) 
    { pointr = cp; rowind = ri; value = va;}

  public:
    dsvd() : svdbase() {}
    dsvd(size_t, size_t, size_t);
    virtual int   get_svals(double* s, size_t K) = 0;
    virtual int   get_svecs(double* U, double* V, size_t K) = 0;
    int   set_options(const OptionsStruct&);
    virtual int   read_options_fromfile(char* file) = 0;
    virtual ~dsvd() { cleanup(); }
  };

}
#endif

