// File: dlas2.h -*- c++ -*-
// Author: Suvrit Sra
// Date: 12 Nov, 2003


#ifndef _D_LAS2_H_
#define _D_LAS2_H_

#include "dlas.h"


namespace mysvd {
  /**************************************************************
   * Sparse svd via eigensystem of A'A matrix   		      *
   * The equivalent symmetric eigenvalue problem:               *
   *                                                            *
   *  B x = lambda x, where x' = (u',v'), lambda = sigma**2,    *
   *                                                            *
   *  B = A'A, and A is m (nrow) by n (ncol) (nrow >> ncol),    *
   *							      *
   *  so that {u, sqrt(lambda), v} is a singular triplet of A.  *
   *  (A' = transpose of A)				      *
   *                                                            *
   * global variables and common areas used by las2 and its     *
   * procedures.                                                *
   **************************************************************/
  class dlas2 : public dlas {
    void   store (long, long, long, double *);
  
    void   lanso(long, long, long, double, double, double *, double *,
                 double *[]);
    void   ritvec(long, FILE*, bool, long n, double kappa, double *ritz, double *bnd,
                  double *alf, double *bet, double *w1, double *w2);
  

    void   stpone (long n, double *wrkptr[]                     );
    double startv (long, double *[]);
    void   imtqlb (long, double*, double*, double*              );

    void  lanczos_step(long, long, long, double *[], double *,
                       double *, double *, double *,
                       long *, long *);
    void   error_bound(long *, double, double, double *, double *);

    void ortbnd(double *alf, double *eta, double *oldeta, double *bet);

    void purge(long n, long ll, double *r, double *q, double *ra,  
               double *qa, double *wrk, double *eta, double *oldeta);

    long   idamax(long, double *, long);
    // Taken from las2.c
    long   landr(long, FILE*, bool, long, long, long, long, double, double, bool,
                 double, double *, double *, double *);
    
    int process_options();
    void setup_default();
  public:
    dlas2() : dlas() {}
    virtual int run();
    virtual int   read_options_fromfile(char* file);
    virtual int   get_svals(double* s, size_t K);
    virtual int   get_svecs(double* U, double* V, size_t K);
  };

}

#endif
