// File: dlas1.h  -*- c++ -*-
// Author: Suvrit Sra
// Date: 12 Nov, 2003


#ifndef _D_LAS1_H_
#define _D_LAS1_H_

#include "dlas.h"

namespace mysvd {

  /************************************************************** 
   * Sparse svd via eigensystem of equivalent 2-cyclic matrix   *
   * The equivalent symmetric eigenvalue problem:		        *
   *			                            				    *
   *  B x = lambda x, where x' = (u',v'), lambda = +/- sigma,   *
   *							                                *
   *      [o  A]						                        *
   *  B = [    ] , and A is m (nrow) by n (ncol).		        *
   *	  [A' o]						                        *
   *							                                *
   * global variables and common areas used by las1 and its     *
   * procedures.						                        *
   **************************************************************/ 
  class dlas1 : public dlas {
  private:
    void   store (long, long, long, double *);
  
    void   lanso(long, long, long, double, double, double *, double *,
                 double *[]);
    void   ritvec(long fpo2, FILE*, bool, long n, double kappa, double *ritz, double *bnd,
                  double *alf, double *bet, double *w1, double *w2);
  

    void   stpone (long n, double *wrkptr[]                     );
    double startv (long, double *[]);
    void   imtqlb (long, double*, double*, double*              );

    void  lanczos_step(long, long, long, double *[], double *,
                       double *, double *, double *,
                       long *, long *);
    void   error_bound(long *, double, double, double *, double *);

    void ortbnd(double *alf, double *eta, double *oldeta, double *bet);

    void purge(long n, long ll, double *r, double *q, double *ra,  
               double *qa, double *wrk, double *eta, double *oldeta);

    long   idamax(long, double *, long);
    // Taken from las1.c
    long  landr(long, FILE*, bool, long, long, long, long, double, double, bool, double,
                double *, double *, double *);

    int process_options();
  public:
    dlas1() : dlas() {}
    void    setup_default();
    virtual int   run();
    virtual int   read_options_fromfile(char* file);
    virtual int   get_svals(double* s, size_t K);
    virtual int   get_svecs(double* U, double* V, size_t K);
  };

}

#endif
